/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.richfaces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ajax4jsf.resource.CompressedScriptRenderer;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.JarResource;
import org.ajax4jsf.resource.ResourceBuilderImpl;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.platform.ui.web.richfaces.AggregatedResources;

public class NuxeoInternetResourceBuilderImpl
extends ResourceBuilderImpl {
    private static final Log log = LogFactory.getLog(NuxeoInternetResourceBuilderImpl.class);
    protected static final String JS_FRAMEWORK_ALL_KEY = "/org/ajax4jsf/framework.pack.js";
    protected static final String JS_UI_ALL_KEY = "/org/richfaces/ui.pack.js";
    protected final Map<String, String> jsRegistredResources = new HashMap<String, String>();
    protected final List<String> blackListedScripts = new ArrayList<String>();
    protected InternetResource UIPack;
    protected InternetResource A4JPack;

    protected void trackRegistredJSResource(String key, InternetResource resource) {
        if (key == null) {
            key = resource.getKey();
        }
        if (key != null && key.endsWith(".js")) {
            if (resource instanceof JarResource) {
                JarResource jarRes = (JarResource)resource;
                String path = jarRes.getPath();
                if (!this.jsRegistredResources.values().contains(key)) {
                    this.jsRegistredResources.put(key, path);
                }
            } else {
                log.debug((Object)("Non Jar resource for key " + key));
            }
        }
    }

    public List<String> getJSResourcesToInclude() {
        ArrayList<String> scripts = new ArrayList<String>();
        List<String> blackList = this.getBlackListedScripts();
        for (String key : this.jsRegistredResources.keySet()) {
            String scriptNameByKey = new Path(key).lastSegment();
            String scriptNameByPath = new Path(this.jsRegistredResources.get(key)).lastSegment();
            if (!blackList.contains(scriptNameByKey) && !blackList.contains(scriptNameByPath)) {
                scripts.add(key);
                continue;
            }
            log.debug((Object)("bypass script with key " + key));
        }
        return scripts;
    }

    public void addResource(InternetResource resource) {
        String key = resource.getKey();
        log.info((Object)("### adding resource : implicit key = " + resource.getKey()));
        this.trackRegistredJSResource(null, resource);
        super.addResource(resource);
    }

    public void addResource(String key, InternetResource resource) {
        log.info((Object)("### adding resource : explicit key = " + key));
        this.trackRegistredJSResource(key, resource);
        super.addResource(key, resource);
    }

    public InternetResource getResource(String key) throws ResourceNotFoundException {
        InternetResource res = null;
        if (JS_FRAMEWORK_ALL_KEY.equals(key)) {
            res = super.getResource(key);
            res = this.getA4JPack(res, key);
        } else if (JS_UI_ALL_KEY.equals(key)) {
            res = super.getResource(key);
            res = this.getUIPack(res, key);
        } else {
            res = super.getResource(key);
        }
        return res;
    }

    protected InternetResource getA4JPack(InternetResource defaultResource, String key) {
        if (this.A4JPack == null) {
            this.buildA4JPack(defaultResource, key);
        }
        return this.A4JPack;
    }

    protected InternetResource getUIPack(InternetResource defaultResource, String key) {
        if (this.UIPack == null) {
            this.buildUIPack(defaultResource, key);
        }
        return this.UIPack;
    }

    protected synchronized void buildA4JPack(InternetResource defaultResource, String key) {
        if (this.A4JPack == null) {
            StringBuffer sb;
            try {
                sb = this.buildAggregatedScript();
            }
            catch (IOException e) {
                log.error((Object)"Error while processing aggregated scripts", (Throwable)e);
                sb = new StringBuffer("Error in processing : " + e.getMessage());
            }
            this.A4JPack = new AggregatedResources(sb, defaultResource.getKey());
            ResourceRenderer renderer = defaultResource.getRenderer(null);
            if (renderer == null) {
                renderer = new CompressedScriptRenderer();
            }
            this.A4JPack.setRenderer(renderer);
        }
    }

    protected synchronized void buildUIPack(InternetResource defaultResource, String key) {
        if (this.UIPack == null) {
            this.UIPack = new AggregatedResources(defaultResource.getKey());
            ResourceRenderer renderer = defaultResource.getRenderer(null);
            if (renderer == null) {
                renderer = new CompressedScriptRenderer();
            }
            this.UIPack.setRenderer(renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getBlackListedScripts() {
        List<String> list = this.blackListedScripts;
        synchronized (list) {
            if (this.blackListedScripts.isEmpty()) {
                this.blackListedScripts.add("framework.pack.js");
                this.blackListedScripts.add("ui.pack.js");
                this.blackListedScripts.add("jquery.js");
            }
        }
        return this.blackListedScripts;
    }

    protected StringBuffer buildAggregatedScript() throws IOException {
        StringBuffer buf = new StringBuffer();
        for (String key : this.getJSResourcesToInclude()) {
            InternetResource res = super.getResource(key);
            InputStream is = res.getResourceAsStream(null);
            if (is != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line + "\n");
                }
                is.close();
                buf.append(sb.toString());
                buf.append("\n");
                continue;
            }
            log.error((Object)("Unable to read InputStream for resource " + key));
        }
        return buf;
    }
}

