/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.UID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.web.FileUploadException;
import org.nuxeo.ecm.platform.ui.web.multipart.Param;

class FileParam
extends Param {
    private static final Log logger = LogFactory.getLog(FileParam.class);
    private String filename;
    private String contentType;
    private int fileSize;
    private ByteArrayOutputStream bOut = null;
    private FileOutputStream fOut = null;
    private File tempFile = null;

    FileParam(String name) {
        super(name);
    }

    public Object getFile() {
        if (null != this.tempFile) {
            return this.tempFile;
        }
        if (null != this.bOut) {
            return this.bOut.toByteArray();
        }
        return null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public File createTempFile() {
        try {
            this.tempFile = File.createTempFile(new UID().toString().replace(":", "-"), ".upload");
            this.fOut = new FileOutputStream(this.tempFile);
        }
        catch (IOException ex) {
            if (this.fOut != null) {
                try {
                    this.fOut.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw new FileUploadException("Could not create temporary file");
        }
        return this.tempFile;
    }

    public void deleteFile() {
        try {
            if (this.fOut != null) {
                this.fOut.close();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
        }
        catch (Exception e) {
            throw new FileUploadException("Could not delete temporary file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        if (this.bOut != null) {
            return this.bOut.toByteArray();
        }
        if (this.tempFile != null && this.tempFile.exists()) {
            FileInputStream fIn = null;
            try {
                long fileLength = this.tempFile.length();
                if (fileLength > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("File content is too long to be allocated as byte[]");
                }
                fIn = new FileInputStream(this.tempFile);
                byte[] fileData = new byte[(int)fileLength];
                int totalRead = 0;
                int read = 0;
                do {
                    if ((read = fIn.read(fileData, totalRead, fileData.length - totalRead)) <= 0) continue;
                    totalRead += read;
                } while (read > 0);
                byte[] byArray = fileData;
                return byArray;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (fIn != null) {
                    try {
                        fIn.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public InputStream getInputStream() {
        if (this.bOut != null) {
            return new ByteArrayInputStream(this.bOut.toByteArray());
        }
        if (this.tempFile != null) {
            try {
                return new FileInputStream(this.tempFile){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        FileParam.this.tempFile.delete();
                    }
                };
            }
            catch (FileNotFoundException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void complete() throws IOException {
        if (this.fOut != null) {
            try {
                this.fOut.close();
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            this.fOut = null;
        }
    }

    @Override
    public void handle(byte[] bytes, int length) throws IOException {
        if (this.fOut != null) {
            this.fOut.write(bytes, 0, length);
            this.fOut.flush();
        } else {
            if (this.bOut == null) {
                this.bOut = new ByteArrayOutputStream();
            }
            this.bOut.write(bytes, 0, length);
        }
        this.fileSize += length;
    }
}

