/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.model.impl;

import java.util.List;
import org.nuxeo.ecm.platform.ui.web.model.SortableDataModel;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;

public abstract class AbstractSortableSelectDataModel
extends SelectDataModelImpl
implements SortableDataModel {
    private static final long serialVersionUID = 7945731561137032048L;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = -1;
    protected String sort;
    protected boolean ascending;

    protected AbstractSortableSelectDataModel() {
    }

    protected AbstractSortableSelectDataModel(String name, List data, List selectedData, String defaultSortColumn) {
        super(name, data, selectedData);
        this.sort = defaultSortColumn;
        this.ascending = this.isDefaultAscending(defaultSortColumn);
    }

    @Override
    public abstract void sort(String var1, boolean var2);

    @Override
    public abstract boolean isDefaultAscending(String var1);

    @Override
    public void sort(String sortColumn) {
        if (sortColumn == null) {
            throw new IllegalArgumentException("Argument sortColumn must not be null.");
        }
        if (this.sort.equals(sortColumn)) {
            this.ascending = !this.ascending;
        } else {
            this.sort = sortColumn;
            this.ascending = this.isDefaultAscending(this.sort);
        }
        this.sort(this.sort, this.ascending);
    }

    @Override
    public String getSort() {
        return this.sort;
    }

    @Override
    public void setSort(String sort) {
        this.sort = sort;
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    @Override
    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

