/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.lifecycle;

import java.util.ArrayList;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NuxeoLifeCycleImpl
extends Lifecycle {
    private static final Log log = LogFactory.getLog(NuxeoLifeCycleImpl.class);
    protected final Lifecycle original;

    public NuxeoLifeCycleImpl(Lifecycle original) {
        this.original = original;
    }

    protected boolean checkDuplicateListener(PhaseListener listener) {
        if (listener != null) {
            ArrayList<String> existingClasses = new ArrayList<String>();
            for (PhaseListener existing : this.getPhaseListeners()) {
                existingClasses.add(existing.getClass().getName());
            }
            if (existingClasses.contains(listener.getClass().getName())) {
                return true;
            }
        }
        return false;
    }

    public void addPhaseListener(PhaseListener listener) {
        if (this.checkDuplicateListener(listener)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Duplicate life cycle listener detected: " + listener.getClass().getName()));
            }
        } else {
            this.original.addPhaseListener(listener);
        }
    }

    public void execute(FacesContext context) throws FacesException {
        this.original.execute(context);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.original.getPhaseListeners();
    }

    public void removePhaseListener(PhaseListener listener) {
        this.original.removePhaseListener(listener);
    }

    public void render(FacesContext context) throws FacesException {
        this.original.render(context);
    }
}

