/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.tree;

import java.io.Serializable;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="treeWidgetActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class TreeWidgetActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @RequestParameter
    protected String selectionListId;
    @RequestParameter
    protected String selectedPath;

    public void addSelectionToList(ActionEvent event) {
        List values;
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent base = ComponentUtils.getBase(component);
        UIEditableList list = ComponentUtils.getComponent(base, this.selectionListId, UIEditableList.class);
        if (list != null && !(values = (List)list.getEditableModel().getWrappedData()).contains(this.selectedPath)) {
            list.addValue(this.selectedPath);
        }
    }

    public DocumentModel getDocumentFromPath(String path) throws ClientException {
        if ("/".equals(path)) {
            return this.documentManager.getRootDocument();
        }
        PathRef ref = new PathRef(path);
        return this.documentManager.exists((DocumentRef)ref) ? this.documentManager.getDocument((DocumentRef)new PathRef(path)) : null;
    }
}

