/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.editor;

import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.component.editor.UIHtmlEditor;
import org.nuxeo.ecm.platform.ui.web.htmleditor.api.HtmlEditorPluginService;
import org.nuxeo.runtime.api.Framework;

public class HtmlEditorRenderer
extends HtmlBasicInputRenderer {
    private static Map<String, String> pluginsOptions;
    private static Map<String, String> toolbarPluginsOptions;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        UIHtmlEditor editorComp = (UIHtmlEditor)component;
        ResponseWriter writer = context.getResponseWriter();
        Locale locale = context.getViewRoot().getLocale();
        writer.startElement("script", (UIComponent)editorComp);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)"tiny_mce/tiny_mce.js", null);
        writer.write(" ");
        writer.endElement("script");
        String editorSelector = editorComp.getEditorSelector();
        writer.startElement("script", (UIComponent)editorComp);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)String.format("var lang = \"%s\";\n", locale.getLanguage()), null);
        writer.writeText((Object)String.format("var editorSelector = \"%s\";\n", editorSelector), null);
        writer.writeText((Object)String.format("var width = \"%s\";\n", editorComp.getWidth()), null);
        writer.writeText((Object)String.format("var height = \"%s\";\n", editorComp.getHeight()), null);
        if (pluginsOptions == null) {
            HtmlEditorPluginService pluginService = (HtmlEditorPluginService)Framework.getLocalService(HtmlEditorPluginService.class);
            pluginsOptions = new HashMap<String, String>();
            pluginsOptions.put("plugins", pluginService.getFormattedPluginsNames());
            toolbarPluginsOptions = new HashMap<String, String>();
            toolbarPluginsOptions.put("toolbar", pluginService.getFormattedToolbarsButtonsNames());
        }
        writer.writeText((Object)String.format("var plugins = \"%s\";\n", pluginsOptions.get("plugins")), null);
        writer.writeText((Object)String.format("var toolbar = \"%s\";\n", toolbarPluginsOptions.get("toolbar")), null);
        writer.endElement("script");
        writer.startElement("script", (UIComponent)editorComp);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)"tiny_mce/tiny_mce_init.js", null);
        writer.write(" ");
        writer.endElement("script");
        String clientId = editorComp.getClientId(context);
        writer.startElement("textarea", (UIComponent)editorComp);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (Boolean.TRUE.equals(editorComp.getDisableHtmlInit())) {
            writer.writeAttribute("class", (Object)(editorSelector + ",disableMCEInit"), null);
        } else {
            writer.writeAttribute("class", (Object)editorSelector, null);
        }
        writer.writeAttribute("rows", (Object)editorComp.getRows(), null);
        writer.writeAttribute("cols", (Object)editorComp.getCols(), null);
        Object currentValue = HtmlEditorRenderer.getCurrentValue(editorComp);
        if (currentValue != null) {
            writer.writeText(currentValue, null);
        } else {
            writer.writeText((Object)"", null);
        }
        writer.endElement("textarea");
        writer.flush();
    }

    protected static Object getCurrentValue(UIInput comp) {
        Object submitted = comp.getSubmittedValue();
        if (submitted != null) {
            return submitted;
        }
        return comp.getValue();
    }

    protected static String generateOptions(Map<String, String> options) {
        ArrayList<String> strOptions = new ArrayList<String>();
        for (Map.Entry<String, String> option : options.entrySet()) {
            strOptions.add(String.format("%s : \"%s\"", option.getKey(), option.getValue()));
        }
        StringBuilder res = new StringBuilder();
        res.append('{');
        res.append(StringUtils.join((Object[])strOptions.toArray(), (String)", "));
        res.append('}');
        return res.toString();
    }
}

