/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.nuxeo.connect.update.PackageVersionRange;
import org.nuxeo.connect.update.Version;

@XmlJavaTypeAdapter(value=PackageDependencyXMLAdapter.class)
public class PackageDependency {
    protected String name;
    protected PackageVersionRange range = PackageVersionRange.ANY;

    public PackageDependency(String expr) {
        int p = expr.indexOf(58);
        if (p == -1) {
            this.name = expr;
        } else {
            this.name = expr.substring(0, p);
            this.range = new PackageVersionRange(expr.substring(p + 1));
        }
    }

    public PackageDependency(String name, Version minVersion) {
        this(name, new PackageVersionRange(minVersion));
    }

    public PackageDependency(String name, Version minVersion, Version maxVersion) {
        this(name, new PackageVersionRange(minVersion, maxVersion));
    }

    public PackageDependency(String name, PackageVersionRange range) {
        this.name = name;
        this.range = range;
    }

    public String getName() {
        return this.name;
    }

    public PackageVersionRange getVersionRange() {
        return this.range;
    }

    public String toString() {
        String vr = this.range.toString();
        if (vr.length() == 0) {
            return this.name;
        }
        return this.name + ':' + vr;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PackageDependency)) {
            return false;
        }
        return this.toString().equals(((PackageDependency)other).toString());
    }

    public static class PackageDependencyXMLAdapter
    extends XmlAdapter<String, PackageDependency> {
        public String marshal(PackageDependency dependency) throws Exception {
            return dependency.toString();
        }

        public PackageDependency unmarshal(String dependency) throws Exception {
            return new PackageDependency(dependency);
        }
    }
}

