/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect;

import java.util.concurrent.TimeUnit;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.http.ProxyHelper;

public class HttpClientBuilderHelper {
    protected static int connectHttpTimeout = Integer.parseInt(NuxeoConnectClient.getProperty("org.nuxeo.connect.http.timeout", "10000"));

    public static HttpClientBuilder getHttpClientBuilder(Integer socketTimeout, Integer connectTimeout, String url) {
        return HttpClientBuilderHelper.getHttpClientBuilder(socketTimeout, connectTimeout, url, true);
    }

    public static HttpClientBuilder getHttpClientBuilderWithoutProxy(Integer socketTimeout, Integer connectTimeout, String url) {
        return HttpClientBuilderHelper.getHttpClientBuilder(socketTimeout, connectTimeout, url, false);
    }

    protected static HttpClientBuilder getHttpClientBuilder(Integer socketTimeout, Integer connectTimeout, String url, boolean useProxy) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec("standard");
        if (socketTimeout != null) {
            requestConfigBuilder.setSocketTimeout(socketTimeout.intValue());
        }
        if (connectTimeout != null) {
            requestConfigBuilder.setConnectTimeout(connectTimeout.intValue());
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (useProxy) {
            ProxyHelper.configureProxyIfNeeded(requestConfigBuilder, (CredentialsProvider)credentialsProvider, url);
        }
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        httpClientBuilder.setConnectionTimeToLive((long)connectHttpTimeout, TimeUnit.MILLISECONDS);
        return httpClientBuilder;
    }
}

