/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.internals.spi.auth;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.nuxeo.client.internals.util.Base64;

public class PortalSSOAuthInterceptor
implements Interceptor {
    public static final String NX_USER = "NX_USER";
    public static final String NX_TOKEN = "NX_TOKEN";
    public static final String NX_RD = "NX_RD";
    public static final String NX_TS = "NX_TS";
    protected final String secret;
    protected final String username;

    public PortalSSOAuthInterceptor(String secretKey, String userName) {
        this.secret = secretKey;
        this.username = userName;
    }

    protected Headers computeHeaders() {
        byte[] hashedToken;
        long ts = new Date().getTime();
        long random = new Random(ts).nextInt();
        String clearToken = String.format("%d:%d:%s:%s", ts, random, this.secret, this.username);
        try {
            hashedToken = MessageDigest.getInstance("MD5").digest(clearToken.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot compute token", e);
        }
        String base64HashedToken = Base64.encode(hashedToken);
        Headers headers = new Headers.Builder().add(NX_TS, String.valueOf(ts)).add(NX_RD, String.valueOf(random)).add(NX_TOKEN, base64HashedToken).add(NX_USER, this.username).build();
        return headers;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request request = chain.request().newBuilder().headers(this.computeHeaders()).method(original.method(), original.body()).build();
        return chain.proceed(request);
    }
}

