/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.nuxeo.client.api.NuxeoClient;
import org.nuxeo.client.api.methods.BatchUploadAPI;
import org.nuxeo.client.api.objects.NuxeoEntity;
import org.nuxeo.client.api.objects.Operation;
import org.nuxeo.client.api.objects.upload.BatchBlob;
import org.nuxeo.client.api.objects.upload.BatchFile;
import org.nuxeo.client.internals.spi.NuxeoClientException;

public class BatchUpload
extends NuxeoEntity {
    @JsonIgnore
    protected int chunkSize;
    protected String batchId;
    protected String fileIdx;
    protected String uploadType;
    protected long uploadedSize;

    public BatchUpload(NuxeoClient nuxeoClient) {
        super(null, nuxeoClient, BatchUploadAPI.class);
    }

    public BatchUpload() {
        super(null);
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getFileIdx() {
        return this.fileIdx;
    }

    public String getUploadType() {
        return this.uploadType;
    }

    public long getUploadedSize() {
        return this.uploadedSize;
    }

    public BatchUpload createBatch() {
        return (BatchUpload)this.getResponse(new Object[0]);
    }

    protected Object upload(String fileName, long fileSize, String fileType, String uploadType, String uploadChunkIndex, String totalChunkCount, String batchId, String fileIdx, File file) {
        RequestBody fbody = RequestBody.create((MediaType)MediaType.parse((String)fileType), (File)file);
        return this.getResponse(fileName, Objects.toString(fileSize), fileType, uploadType, uploadChunkIndex, totalChunkCount, batchId, fileIdx, fbody);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BatchUpload upload(String name, long length, String fileType, String batchId, String fileIdx, File file) {
        if (this.chunkSize == 0) {
            return (BatchUpload)this.upload(name, length, fileType, "normal", "0", "1", batchId, fileIdx, file);
        }
        int partCounter = 1;
        int sizeOfFiles = this.chunkSize;
        ArrayList<File> files = new ArrayList<File>();
        BatchUpload batchUpload = null;
        byte[] buffer = new byte[sizeOfFiles];
        int tmp = 0;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            while ((tmp = bis.read(buffer)) > 0) {
                FileOutputStream out;
                block27: {
                    File newFile = new File(file.getParent(), name + "." + String.format("%03d", partCounter++));
                    out = new FileOutputStream(newFile);
                    Throwable throwable = null;
                    try {
                        out.write(buffer, 0, tmp);
                        files.add(newFile);
                        if (out == null) continue;
                        if (throwable == null) break block27;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable == null) {
                                out.close();
                                throw throwable3;
                            }
                            try {
                                out.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        out.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                out.close();
            }
        }
        catch (IOException reason) {
            throw new NuxeoClientException(reason);
        }
        tmp = 0;
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File chunk = (File)iterator.next();
            if (tmp == files.size() - 1) {
                batchUpload = (BatchUpload)this.upload(name, length, fileType, "chunked", Objects.toString(tmp), Objects.toString(files.size()), batchId, fileIdx, chunk);
                continue;
            }
            this.upload(name, length, fileType, "chunked", Objects.toString(tmp), Objects.toString(files.size()), batchId, fileIdx, chunk);
            ++tmp;
        }
        return batchUpload;
    }

    public void cancel(String batchId) {
        this.getResponse(batchId);
    }

    public void cancel() {
        this.cancel(this.batchId);
    }

    public List<BatchFile> fetchBatchFiles(String batchId) {
        return (List)this.getResponse(batchId);
    }

    public BatchFile fetchBatchFile(String batchId, String fileIdx) {
        return (BatchFile)this.getResponse(batchId, fileIdx);
    }

    public BatchFile fetchBatchFile(String fileIdx) {
        return this.fetchBatchFile(this.batchId, fileIdx);
    }

    public List<BatchFile> fetchBatchFiles() {
        return this.fetchBatchFiles(this.batchId);
    }

    public BatchBlob getBatchBlob() {
        return this.getBatchBlob(this.batchId, this.fileIdx);
    }

    private BatchBlob getBatchBlob(String batchId, String fileIdx) {
        return new BatchBlob(batchId, fileIdx);
    }

    public BatchUpload chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public BatchUpload enableChunk() {
        this.chunkSize = 0x100000;
        return this;
    }

    public Object execute(Operation operation) {
        return this.execute(this.batchId, this.fileIdx, operation);
    }

    public Object execute(String batchId, String fileIdx, Operation operation) {
        return this.nuxeoClient.automation().execute(batchId, fileIdx, operation.getOperationId(), operation.getBody());
    }
}

