/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.nuxeo.client.api.ConstantsV1;
import org.nuxeo.client.api.NuxeoClient;
import org.nuxeo.client.api.objects.Document;
import org.nuxeo.client.api.objects.Documents;
import org.nuxeo.client.api.objects.blob.Blob;
import org.nuxeo.client.api.objects.blob.Blobs;
import org.nuxeo.client.internals.spi.NuxeoClientException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class NuxeoEntity<T> {
    @JsonProperty(value="entity-type")
    protected final String entityType;
    @JsonProperty(value="repository")
    protected String repositoryName;
    @JsonIgnore
    protected boolean refreshCache = false;
    @JsonIgnore
    protected NuxeoClient nuxeoClient;
    @JsonIgnore
    protected Object api;
    @JsonIgnore
    protected Class<Object> apiClass;

    public NuxeoEntity(String entityType) {
        this.entityType = entityType;
    }

    public NuxeoEntity(String entityType, NuxeoClient nuxeoClient, Class apiClass) {
        this.entityType = entityType;
        this.nuxeoClient = nuxeoClient;
        this.apiClass = apiClass;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void execute(Callback<T> callback, Object ... parametersArray) {
        if (this.api == null) {
            this.api = this.nuxeoClient.getRetrofit().create(this.apiClass);
        }
        if (this.nuxeoClient == null) {
            throw new NuxeoClientException("You should pass to your Nuxeo object the client instance");
        }
        String method = this.getCurrentMethodName();
        Call<T> methodResult = this.getCall(this.api, method, parametersArray);
        methodResult.enqueue(callback);
    }

    protected Object getResponse(Object ... parametersArray) {
        if (this.nuxeoClient == null) {
            throw new NuxeoClientException("You should pass to your Nuxeo object the client instance");
        }
        if (this.api == null) {
            this.api = this.nuxeoClient.getRetrofit().create(this.apiClass);
        }
        String method = this.getCurrentMethodName();
        Call<T> methodResult = this.getCall(this.api, method, parametersArray);
        String cacheKey = "";
        if (this.nuxeoClient.isCacheEnabled()) {
            if (this.refreshCache) {
                this.refreshCache = false;
                this.nuxeoClient.getNuxeoCache().invalidateAll();
            } else {
                cacheKey = this.computeCacheKey(methodResult);
                NuxeoEntity result = (NuxeoEntity)this.nuxeoClient.getNuxeoCache().getBody(cacheKey);
                if (result != null) {
                    return result;
                }
            }
        }
        try {
            Object body;
            Response response = methodResult.execute();
            if (!response.isSuccessful() && response.code() != 308) {
                String errorBody = response.errorBody().string();
                NuxeoClientException nuxeoClientException = "".equals(errorBody) ? new NuxeoClientException(response.code(), response.message()) : (!ConstantsV1.APPLICATION_JSON.equals((Object)response.raw().body().contentType()) ? new NuxeoClientException(response.code(), errorBody) : (NuxeoClientException)this.nuxeoClient.getConverterFactory().readJSON(errorBody, NuxeoClientException.class));
                throw nuxeoClientException;
            }
            if (this.nuxeoClient.isCacheEnabled()) {
                this.nuxeoClient.getNuxeoCache().put(cacheKey, response);
            }
            if ((body = response.body()) instanceof ResponseBody) {
                return body;
            }
            if (body == null) {
                if (response.code() == 204) {
                    if ("application/nuxeo-empty-list".equals(response.headers().get("Content-Type"))) {
                        return new Blobs();
                    }
                    return null;
                }
                return response;
            }
            return this.reconnectObject(body, response.headers(), this.api, this.nuxeoClient);
        }
        catch (IOException reason) {
            throw new NuxeoClientException(reason);
        }
    }

    protected String computeCacheKey(Call<?> methodResult) {
        MessageDigest digest;
        Request originalRequest = methodResult.request();
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update((originalRequest.toString() + originalRequest.headers().toString()).getBytes());
        byte[] messageDigest = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte msg : messageDigest) {
            hexString.append(Integer.toHexString(0xFF & msg));
        }
        return hexString.toString();
    }

    protected Call<T> getCall(Object api, String methodName, Object ... parametersArray) {
        try {
            Method[] methods = api.getClass().getInterfaces()[0].getMethods();
            ArrayList<Object> parameters = new ArrayList<Object>(Arrays.asList(parametersArray));
            if (this.repositoryName != null) {
                parameters.add(this.repositoryName);
            }
            parametersArray = parameters.toArray();
            Method method = null;
            for (Method currentMethod : methods) {
                if (!currentMethod.getName().equals(methodName) || currentMethod.getParameterTypes().length != parametersArray.length) continue;
                method = currentMethod;
                break;
            }
            if (method == null) {
                throw new NuxeoClientException(String.format("No method found for API %s and method name '%s'. Check method name and parameters.", this.apiClass, methodName));
            }
            return (Call)method.invoke(api, parametersArray);
        }
        catch (IllegalAccessException | IllegalArgumentException reason) {
            throw new NuxeoClientException(String.format("An issue has occured in the method found for API %s and method name '%s'. Check method and parameters types.", this.apiClass, methodName), reason);
        }
        catch (InvocationTargetException reason) {
            throw new NuxeoClientException(reason.getTargetException().getMessage(), reason);
        }
    }

    protected String getCurrentMethodName() {
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        return stackTraceElements[2].getMethodName();
    }

    protected Object reconnectObject(Object entity, Headers headers, Object api, NuxeoClient nuxeoClient) {
        if (entity instanceof NuxeoEntity) {
            String contentDisposition;
            ((NuxeoEntity)entity).nuxeoClient = nuxeoClient;
            ((NuxeoEntity)entity).api = api;
            ((NuxeoEntity)entity).apiClass = this.apiClass;
            if (entity instanceof Documents) {
                for (Document doc : ((Documents)entity).getDocuments()) {
                    doc.nuxeoClient = nuxeoClient;
                    doc.api = api;
                    doc.apiClass = this.apiClass;
                }
            } else if (entity instanceof Blobs) {
                for (Blob blob : ((Blobs)entity).getBlobs()) {
                    blob.nuxeoClient = nuxeoClient;
                    blob.api = api;
                    blob.apiClass = this.apiClass;
                }
            } else if (entity instanceof Blob && (contentDisposition = headers.get("Content-Disposition")) != null) {
                String fileName = contentDisposition.replaceFirst(".*filename\\*?=(UTF-8'')?(.*)", "$2");
                try {
                    fileName = URLDecoder.decode(fileName, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                ((Blob)entity).setFileName(fileName);
            }
            return entity;
        }
        if (entity instanceof List) {
            ArrayList<NuxeoEntity> entities = new ArrayList<NuxeoEntity>();
            List l = (List)entity;
            for (Object item : l) {
                if (!(item instanceof NuxeoEntity)) continue;
                ((NuxeoEntity)item).nuxeoClient = nuxeoClient;
                ((NuxeoEntity)item).api = api;
                ((NuxeoEntity)item).apiClass = this.apiClass;
                entities.add((NuxeoEntity)item);
            }
            return entities;
        }
        return entity;
    }
}

