/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.nuxeo.client.api.objects.Document;
import org.nuxeo.client.api.objects.NuxeoEntity;

public class Documents
extends NuxeoEntity {
    @JsonProperty(value="entries")
    protected List<Document> documents;
    protected Boolean isPaginable;
    protected int resultsCount;
    protected int pageSize;
    protected int maxPageSize;
    protected int currentPageSize;
    protected int currentPageIndex;
    protected int numberOfPages;
    protected Boolean isPreviousPageAvailable;
    protected Boolean isNextPageAvailable;
    protected Boolean isLastPageAvailable;
    protected Boolean isSortable;
    protected Boolean hasError;
    protected String errorMessage;
    protected int totalSize;
    protected int pageIndex;
    protected int pageCount;

    public Documents() {
        super("documents");
    }

    public Documents(List<Document> documents) {
        super("documents");
        this.documents = documents;
    }

    public void addDocument(Document document) {
        this.documents.add(document);
    }

    public void removeDocument(Document document) {
        this.documents.remove(document);
    }

    public Document getDocument(int position) {
        return this.documents.get(position);
    }

    public int size() {
        return this.documents.size();
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public int getResultsCount() {
        return this.resultsCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getCurrentPageSize() {
        return this.currentPageSize;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public Boolean getIsPaginable() {
        return this.isPaginable;
    }

    public Boolean getIsPreviousPageAvailable() {
        return this.isPreviousPageAvailable;
    }

    public Boolean getIsNextPageAvailable() {
        return this.isNextPageAvailable;
    }

    public Boolean getIsLastPageAvailable() {
        return this.isLastPageAvailable;
    }

    public Boolean getIsSortable() {
        return this.isSortable;
    }

    public Boolean getHasError() {
        return this.hasError;
    }
}

