/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import org.nuxeo.client.api.objects.Documents;
import org.nuxeo.client.api.objects.NuxeoEntity;
import org.nuxeo.client.api.objects.acl.ACE;
import org.nuxeo.client.api.objects.acl.ACP;
import org.nuxeo.client.api.objects.audit.Audit;
import org.nuxeo.client.api.objects.blob.Blob;
import org.nuxeo.client.api.objects.task.Task;
import org.nuxeo.client.api.objects.workflow.Workflow;
import org.nuxeo.client.api.objects.workflow.Workflows;
import org.nuxeo.client.internals.spi.NuxeoClientException;
import retrofit2.Callback;

public class Document
extends NuxeoEntity {
    protected String path;
    protected final String type;
    protected String state;
    protected String lockOwner;
    protected String lockCreated;
    protected String versionLabel;
    protected String isCheckedOut;
    protected String lastModified;
    protected Map<String, Object> properties;
    @JsonIgnore
    protected transient Map<String, Object> dirtyProperties;
    protected Map<String, Object> contextParameters;
    protected String changeToken;
    protected List<String> facets;
    protected String parentRef;
    protected String uid;
    protected String title;
    protected String name;

    public Document(String id, String type, List<String> facets, String changeToken, String path, String state, String lockOwner, String lockCreated, String repositoryName, String versionLabel, String isCheckedOut, Map<String, Object> properties, Map<String, Object> contextParameters) {
        super("document");
        this.uid = id;
        this.changeToken = changeToken;
        this.facets = facets;
        this.path = path;
        this.type = type;
        this.state = state;
        this.lockOwner = lockOwner;
        this.lockCreated = lockCreated;
        this.repositoryName = repositoryName;
        this.versionLabel = versionLabel;
        this.isCheckedOut = isCheckedOut;
        this.contextParameters = contextParameters == null ? new HashMap() : contextParameters;
        this.properties = properties == null ? new HashMap() : properties;
        this.dirtyProperties = new HashMap<String, Object>();
    }

    public Document(String title, String type) {
        super("document");
        this.uid = null;
        this.title = title;
        this.name = title;
        this.type = type;
        this.changeToken = null;
        this.facets = null;
        this.path = null;
        this.state = null;
        this.lockOwner = null;
        this.lockCreated = null;
        this.repositoryName = null;
        this.versionLabel = null;
        this.isCheckedOut = null;
        this.properties = new HashMap<String, Object>();
        this.dirtyProperties = new HashMap<String, Object>();
        this.contextParameters = new HashMap<String, Object>();
    }

    public Document() {
        super("document");
        this.uid = null;
        this.title = "File";
        this.name = "File";
        this.type = "File";
        this.changeToken = null;
        this.facets = null;
        this.path = null;
        this.state = null;
        this.lockOwner = null;
        this.lockCreated = null;
        this.repositoryName = null;
        this.versionLabel = null;
        this.isCheckedOut = null;
        this.properties = new HashMap<String, Object>();
        this.dirtyProperties = new HashMap<String, Object>();
        this.contextParameters = new HashMap<String, Object>();
    }

    public Document(Document document) {
        super("document");
        this.type = "File";
        for (Field field : document.getClass().getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            try {
                Class<?> superclass = this.getClass().getSuperclass();
                if (superclass.equals(NuxeoEntity.class)) {
                    throw new NuxeoClientException("You should never use this constructor unless you're using a subclass of Document");
                }
                superclass.getDeclaredField(field.getName()).set(this, field.get(document));
            }
            catch (IllegalAccessException | NoSuchFieldException reason) {
                throw new NuxeoClientException(reason);
            }
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getId() {
        return this.uid;
    }

    public String getInputType() {
        return "document";
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getLock() {
        if (this.lockOwner != null && this.lockCreated != null) {
            return this.lockOwner + ":" + this.lockCreated;
        }
        return null;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockCreated() {
        return this.lockCreated;
    }

    public boolean isLocked() {
        return this.lockOwner != null;
    }

    public String getState() {
        return this.state;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public Boolean isCheckedOut() {
        return this.isCheckedOut == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.isCheckedOut));
    }

    public String getTitle() {
        return this.title;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public List<String> getFacets() {
        return this.facets;
    }

    public String getIsCheckedOut() {
        return this.isCheckedOut;
    }

    public String getParentRef() {
        return this.parentRef;
    }

    public String getUid() {
        return this.uid;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public void set(String key, Object value) {
        this.properties.put(key, value);
        this.dirtyProperties.put(key, value);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getPropertyValue(String key) {
        return this.properties.get(key);
    }

    public void setPropertyValue(String key, Object value) {
        this.properties.put(key, value);
        this.dirtyProperties.put(key, value);
    }

    public void followLifeCycle(String state) {
        this.state = state;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public void setLockCreated(String lockCreated) {
        this.lockCreated = lockCreated;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public void setIsCheckedOut(String isCheckedOut) {
        this.isCheckedOut = isCheckedOut;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setDirtyProperties(Map<String, Object> dirtyProperties) {
        this.dirtyProperties = dirtyProperties;
    }

    public void setContextParameters(Map<String, Object> contextParameters) {
        this.contextParameters = contextParameters;
    }

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    public void setFacets(List<String> facets) {
        this.facets = facets;
    }

    public void setParentRef(String parentRef) {
        this.parentRef = parentRef;
    }

    public void setId(String uid) {
        this.uid = uid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> getDirtyProperties() {
        return this.dirtyProperties;
    }

    public Map<String, Object> getContextParameters() {
        return this.contextParameters;
    }

    public Document updateDocument() {
        return (Document)this.getResponse(this.uid, this);
    }

    public Audit fetchAudit() {
        return this.fetchAuditById(this.uid);
    }

    public Audit fetchAuditById(String documentId) {
        return (Audit)this.getResponse(documentId);
    }

    public void fetchAudit(Callback<Audit> callback) {
        this.execute(callback, this.uid);
    }

    public void fetchAuditById(String documentId, Callback<Audit> callback) {
        this.execute(callback, documentId);
    }

    public ACP fetchPermissions() {
        return this.fetchPermissionsById(this.uid);
    }

    protected ACP fetchPermissionsById(String documentId) {
        return (ACP)this.getResponse(documentId);
    }

    public void addPermission(ACE ace) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", ace.getUsername());
        this.setPermissionAutomationParameters(ace, params);
        this.nuxeoClient.automation("Document.AddPermission").input(this).parameters(params).execute();
    }

    protected void setPermissionAutomationParameters(ACE ace, Map<String, Object> params) {
        params.put("permission", ace.getPermission());
        params.put("begin", ace.getBeginAsString());
        params.put("end", ace.getEndAsString());
        params.put("creator", ace.getCreator());
        params.put("blockInheritance", ace.isBlockInheritance());
        params.put("comment", ace.getComment());
        params.put("notify", ace.isNotify());
    }

    public void addInvitation(ACE ace, String email) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("email", email);
        this.setPermissionAutomationParameters(ace, params);
        this.nuxeoClient.automation("Document.AddPermission").input(this).parameters(params).execute();
    }

    public void removePermission(String username) {
        this.removePermission(null, username, "local");
    }

    public void removePermission(String aceId, String username, String ACLName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", aceId);
        params.put("user", username);
        params.put("acl", ACLName);
        this.nuxeoClient.automation("Document.RemovePermission").input(this).parameters(params).execute();
    }

    public void fetchACP(Callback<ACP> callback) {
        this.execute(callback, this.uid);
    }

    protected void fetchACPById(String documentId, Callback<ACP> callback) {
        this.execute(callback, documentId);
    }

    public void addPermission(ACE ace, Callback<ResponseBody> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", ace.getUsername());
        this.setPermissionAutomationParameters(ace, params);
        this.nuxeoClient.automation("Document.AddPermission").input(this).parameters(params).execute(callback, new Object[0]);
    }

    public void addInvitation(ACE ace, String email, Callback<ResponseBody> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("email", email);
        this.setPermissionAutomationParameters(ace, params);
        this.nuxeoClient.automation("Document.AddPermission").input(this).parameters(params).execute(callback, new Object[0]);
    }

    public Documents fetchChildren() {
        return this.fetchChildrenById(this.uid);
    }

    public Documents fetchChildrenById(String parentId) {
        return (Documents)this.getResponse(parentId);
    }

    public void fetchChildren(Callback<Documents> callback) {
        this.execute(callback, this.uid);
    }

    public void fetchChildrenById(String parentId, Callback<Documents> callback) {
        this.execute(callback, parentId);
    }

    public Blob fetchBlob() {
        return this.fetchBlobById(this.uid, "file:content");
    }

    public Blob fetchBlob(String fieldPath) {
        return this.fetchBlobById(this.uid, fieldPath);
    }

    public Blob fetchBlobById(String uid, String fieldPath) {
        return (Blob)this.getResponse(uid, fieldPath);
    }

    public void fetchBlob(Callback<Blob> callback) {
        this.execute(callback, this.uid, "file:content");
    }

    public void fetchBlob(String fieldPath, Callback<Blob> callback) {
        this.execute(callback, this.uid, fieldPath);
    }

    public void fetchBlobById(String uid, String fieldPath, Callback<Blob> callback) {
        this.execute(callback, uid, fieldPath);
    }

    public Workflows fetchWorkflowInstances() {
        return (Workflows)this.getResponse(this.uid);
    }

    public Workflow startWorkflowInstance(Workflow workflow) {
        return this.startWorkflowInstanceWithDocId(workflow);
    }

    public Workflow startWorkflowInstanceWithDocId(Workflow workflow) {
        return (Workflow)this.getResponse(this.uid, workflow);
    }

    public void fetchWorkflowInstances(Callback<Workflows> callback) {
        this.execute(callback, this.uid);
    }

    public void startWorkflowInstance(Workflow workflow, Callback<Workflow> callback) {
        this.execute(callback, this.uid, workflow);
    }

    public Task fetchTask() {
        return this.fetchTaskById(this.uid);
    }

    public Task fetchTaskById(String documentId) {
        return (Task)this.getResponse(documentId);
    }
}

