/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.client.api.Client;
import org.nuxeo.client.api.ConstantsV1;
import org.nuxeo.client.api.NuxeoClient$$Lambda$1;
import org.nuxeo.client.api.cache.NuxeoResponseCache;
import org.nuxeo.client.api.cache.ResultCacheInMemory;
import org.nuxeo.client.api.marshaller.NuxeoConverterFactory;
import org.nuxeo.client.api.marshaller.NuxeoMarshaller;
import org.nuxeo.client.api.objects.Operation;
import org.nuxeo.client.api.objects.Repository;
import org.nuxeo.client.api.objects.directory.DirectoryManager;
import org.nuxeo.client.api.objects.task.TaskManager;
import org.nuxeo.client.api.objects.upload.BatchUpload;
import org.nuxeo.client.api.objects.user.CurrentUser;
import org.nuxeo.client.api.objects.user.UserManager;
import org.nuxeo.client.internals.spi.NuxeoClientException;
import org.nuxeo.client.internals.spi.auth.BasicAuthInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class NuxeoClient
implements Client {
    protected final OkHttpClient.Builder okhttpBuilder = new OkHttpClient.Builder();
    protected final Repository repository;
    protected final Operation automation;
    protected final BatchUpload batchUpload;
    protected final UserManager userManager;
    protected final DirectoryManager directoryManager;
    protected final TaskManager taskManager;
    protected final NuxeoConverterFactory converterFactory;
    protected final Retrofit.Builder retrofitBuilder;
    protected CurrentUser currentUser;
    protected NuxeoResponseCache nuxeoCache;
    protected Retrofit retrofit;

    public NuxeoClient(String url, String userName, String password) {
        if (this.okhttpBuilder.interceptors().isEmpty()) {
            if (userName != null && password != null) {
                this.setAuthenticationMethod(new BasicAuthInterceptor(userName, password));
            } else {
                throw new NuxeoClientException("Define credentials");
            }
        }
        this.converterFactory = NuxeoConverterFactory.create();
        this.retrofitBuilder = new Retrofit.Builder().baseUrl(url + "/api/v1/").addConverterFactory((Converter.Factory)this.converterFactory);
        this.retrofit();
        this.automation = new Operation(this);
        this.repository = new Repository(this);
        this.userManager = new UserManager(this);
        this.directoryManager = new DirectoryManager(this);
        this.batchUpload = new BatchUpload(this);
        this.taskManager = new TaskManager(this);
    }

    public NuxeoClient registerMarshaller(NuxeoMarshaller<?> marshaller) {
        this.converterFactory.registerMarshaller(marshaller);
        return this;
    }

    public NuxeoClient clearMarshaller() {
        this.converterFactory.clearMarshaller();
        return this;
    }

    public NuxeoClient enableDefaultCache() {
        this.nuxeoCache = new ResultCacheInMemory();
        return this;
    }

    public void logout() {
        this.okhttpBuilder.interceptors().clear();
        this.retrofit();
    }

    public NuxeoConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    @Override
    public NuxeoClient header(String header, String value) {
        this.okhttpBuilder.interceptors().add(NuxeoClient$$Lambda$1.lambdaFactory$(header, value));
        this.retrofit();
        return this;
    }

    public NuxeoClient enrichers(String ... enrichers) {
        this.header("X-NXenrichers.document", StringUtils.join(Arrays.asList(enrichers), (String)","));
        return this;
    }

    public NuxeoClient voidOperation(boolean value) {
        this.header("X-NXVoidOperation", Boolean.toString(value));
        return this;
    }

    public NuxeoClient transactionTimeout(long timeout) {
        this.header("Nuxeo-Transaction-Timeout", String.valueOf(timeout));
        return this;
    }

    public NuxeoClient fetch(String ... fetchs) {
        for (String fetch : fetchs) {
            this.header("X-NXfetch.document", fetch);
        }
        return this;
    }

    public NuxeoClient depth(String value) {
        this.header("depth", value);
        return this;
    }

    public NuxeoClient version(String value) {
        this.header("X-Versioning-Option", value);
        return this;
    }

    public NuxeoClient schemas(String ... properties) {
        this.header("X-NXproperties", StringUtils.join(Arrays.asList(properties), (String)","));
        return this;
    }

    @Override
    public NuxeoClient setCache(NuxeoResponseCache nuxeoCache) {
        this.nuxeoCache = nuxeoCache;
        return this;
    }

    @Override
    public NuxeoClient setAuthenticationMethod(Interceptor interceptor) {
        this.okhttpBuilder.interceptors().add(interceptor);
        return this;
    }

    @Override
    public NuxeoClient timeout(long timeout) {
        this.okhttpBuilder.connectTimeout(timeout, TimeUnit.SECONDS);
        this.retrofit();
        return this;
    }

    @Override
    public String getBaseUrl() {
        return this.retrofit.baseUrl().toString();
    }

    @Override
    public void shutdown() {
        this.logout();
    }

    @Override
    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    protected void retrofit() {
        OkHttpClient okHttpClient = this.okhttpBuilder.build();
        this.retrofit = this.retrofitBuilder.callFactory((Call.Factory)okHttpClient).build();
    }

    @Override
    public NuxeoResponseCache getNuxeoCache() {
        return this.nuxeoCache;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.nuxeoCache != null;
    }

    public Repository repository() {
        return this.repository;
    }

    public CurrentUser getCurrentUser() {
        return this.currentUser;
    }

    public CurrentUser fetchCurrentUser() {
        this.currentUser = new CurrentUser(this);
        return this.currentUser.getCurrentUser();
    }

    public Repository repositoryName(String repositoryName) {
        return this.repository(repositoryName);
    }

    public Repository repository(String repositoryName) {
        this.repository.repositoryName(repositoryName);
        return this.repository;
    }

    public Operation automation() {
        return this.automation;
    }

    public Operation automation(String operationId) {
        this.automation.setOperationId(operationId);
        return this.automation;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public Response get(String url) {
        Request request = new Request.Builder().url(url).build();
        try {
            return this.retrofit.callFactory().newCall(request).execute();
        }
        catch (IOException e) {
            throw new NuxeoClientException(e);
        }
    }

    @Override
    public Response delete(String url, String json) {
        Request request;
        if (json != null) {
            RequestBody body = RequestBody.create((MediaType)ConstantsV1.APPLICATION_JSON_CHARSET_UTF_8, (String)json);
            request = new Request.Builder().url(url).delete(body).build();
        } else {
            request = new Request.Builder().url(url).build();
        }
        try {
            return this.retrofit.callFactory().newCall(request).execute();
        }
        catch (IOException e) {
            throw new NuxeoClientException(e);
        }
    }

    @Override
    public Response put(String url, String json) {
        Request request;
        if (json != null) {
            RequestBody body = RequestBody.create((MediaType)ConstantsV1.APPLICATION_JSON_CHARSET_UTF_8, (String)json);
            request = new Request.Builder().url(url).put(body).build();
        } else {
            request = new Request.Builder().url(url).build();
        }
        try {
            return this.retrofit.callFactory().newCall(request).execute();
        }
        catch (IOException e) {
            throw new NuxeoClientException(e);
        }
    }

    @Override
    public Response post(String url, String json) {
        Request request;
        if (json != null) {
            RequestBody body = RequestBody.create((MediaType)ConstantsV1.APPLICATION_JSON_CHARSET_UTF_8, (String)json);
            request = new Request.Builder().url(url).post(body).build();
        } else {
            request = new Request.Builder().url(url).build();
        }
        try {
            return this.retrofit.callFactory().newCall(request).execute();
        }
        catch (IOException e) {
            throw new NuxeoClientException(e);
        }
    }

    public BatchUpload fetchUploadManager() {
        return this.batchUpload.createBatch();
    }

    public BatchUpload batchUpload() {
        return this.batchUpload;
    }

    private static /* synthetic */ Response lambda$header$0(String header, String value, Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        request = request.newBuilder().addHeader(header, value).build();
        Response response = chain.proceed(request);
        return response;
    }

    static /* synthetic */ Response access$lambda$0(String string, String string2, Interceptor.Chain chain) {
        return NuxeoClient.lambda$header$0(string, string2, chain);
    }
}

