/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.writer;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.neo4j.kernel.api.impl.index.partition.IndexPartition;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndex;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;

public class PartitionedIndexWriter
implements LuceneIndexWriter {
    private LuceneSchemaIndex index;
    private final Integer MAXIMUM_PARTITION_SIZE = Integer.getInteger("luceneSchemaIndex.maxPartitionSize", 0x73333333);

    public PartitionedIndexWriter(LuceneSchemaIndex index) throws IOException {
        this.index = index;
    }

    @Override
    public void addDocument(Document doc) throws IOException {
        this.getIndexWriter().addDocument((Iterable)doc);
    }

    @Override
    public void addDocuments(Iterable<Document> documents) throws IOException {
        this.getIndexWriter().addDocuments(documents);
    }

    @Override
    public void updateDocument(Term term, Document doc) throws IOException {
        List<IndexPartition> partitions = this.index.getPartitions();
        for (IndexPartition partition : partitions) {
            partition.getIndexWriter().updateDocument(term, (Iterable)doc);
        }
    }

    @Override
    public void deleteDocuments(Query query) throws IOException {
        List<IndexPartition> partitions = this.index.getPartitions();
        for (IndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Query[]{query});
        }
    }

    @Override
    public void deleteDocuments(Term term) throws IOException {
        List<IndexPartition> partitions = this.index.getPartitions();
        for (IndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Term[]{term});
        }
    }

    private synchronized IndexWriter getIndexWriter() throws IOException {
        List<IndexPartition> indexPartitions = this.index.getPartitions();
        Optional<IndexPartition> writablePartition = indexPartitions.stream().filter(this::writablePartition).findFirst();
        if (writablePartition.isPresent()) {
            return writablePartition.get().getIndexWriter();
        }
        IndexPartition indexPartition = this.index.addNewPartition();
        return indexPartition.getIndexWriter();
    }

    private boolean writablePartition(IndexPartition partition) {
        return partition.getIndexWriter().numDocs() < this.MAXIMUM_PARTITION_SIZE;
    }
}

