/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.kernel.api.index.ArrayEncoder;

enum ValueEncoding {
    Number{

        @Override
        String key() {
            return "number";
        }

        @Override
        boolean canEncode(Object value) {
            return value instanceof Number;
        }

        @Override
        Field encodeField(Object value) {
            return new DoubleField(this.key(), ((Number)value).doubleValue(), Field.Store.NO);
        }

        @Override
        void setFieldValue(Object value, Field field) {
            field.setDoubleValue(((Number)value).doubleValue());
        }

        @Override
        Query encodeQuery(Object value) {
            Double doubleValue = ((Number)value).doubleValue();
            return new ConstantScoreQuery((Query)NumericRangeQuery.newDoubleRange((String)this.key(), (Double)doubleValue, (Double)doubleValue, (boolean)true, (boolean)true));
        }
    }
    ,
    Array{

        @Override
        String key() {
            return "array";
        }

        @Override
        boolean canEncode(Object value) {
            return value.getClass().isArray();
        }

        @Override
        Field encodeField(Object value) {
            return ValueEncoding.stringField(this.key(), ArrayEncoder.encode((Object)value));
        }

        @Override
        void setFieldValue(Object value, Field field) {
            field.setStringValue(ArrayEncoder.encode((Object)value));
        }

        @Override
        Query encodeQuery(Object value) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(), ArrayEncoder.encode((Object)value))));
        }
    }
    ,
    Bool{

        @Override
        String key() {
            return "bool";
        }

        @Override
        boolean canEncode(Object value) {
            return value instanceof Boolean;
        }

        @Override
        Field encodeField(Object value) {
            return ValueEncoding.stringField(this.key(), value.toString());
        }

        @Override
        void setFieldValue(Object value, Field field) {
            field.setStringValue(value.toString());
        }

        @Override
        Query encodeQuery(Object value) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(), value.toString())));
        }
    }
    ,
    String{

        @Override
        String key() {
            return "string";
        }

        @Override
        boolean canEncode(Object value) {
            return true;
        }

        @Override
        Field encodeField(Object value) {
            return ValueEncoding.stringField(this.key(), value.toString());
        }

        @Override
        void setFieldValue(Object value, Field field) {
            field.setStringValue(value.toString());
        }

        @Override
        Query encodeQuery(Object value) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(), value.toString())));
        }
    };

    private static final ValueEncoding[] AllEncodings;

    abstract String key();

    abstract boolean canEncode(Object var1);

    abstract Field encodeField(Object var1);

    abstract void setFieldValue(Object var1, Field var2);

    abstract Query encodeQuery(Object var1);

    public static ValueEncoding forKey(String key) {
        for (ValueEncoding encoding : AllEncodings) {
            if (!encoding.key().equals(key)) continue;
            return encoding;
        }
        throw new IllegalArgumentException("Unknown key: " + key);
    }

    public static ValueEncoding forValue(Object value) {
        for (ValueEncoding encoding : AllEncodings) {
            if (!encoding.canEncode(value)) continue;
            return encoding;
        }
        throw new IllegalStateException("Unable to encode the value " + value);
    }

    private static Field stringField(String identifier, String value) {
        return new StringField(identifier, value, Field.Store.NO);
    }

    static {
        AllEncodings = ValueEncoding.values();
    }
}

