/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.storestrategy;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.collector.DocValuesAccess;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.BitmapExtractor;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.LongPageIterator;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;

class PageOfRangesIterator
extends PrefetchingIterator<PrimitiveLongIterator> {
    private IndexSearcher searcher;
    private final Query query;
    private final BitmapDocumentFormat format;
    private final int rangesPerPage;
    private final int[] labels;
    private DocValuesCollector.LongValuesIterator rangesIterator;

    PageOfRangesIterator(BitmapDocumentFormat format, IndexSearcher searcher, int rangesPerPage, Query query, int ... labels) {
        this.searcher = searcher;
        this.query = query;
        this.format = format;
        this.rangesPerPage = rangesPerPage;
        this.labels = labels;
        if (labels.length == 0) {
            throw new IllegalArgumentException("At least one label required");
        }
    }

    protected PrimitiveLongIterator fetchNextOrNull() {
        if (this.searcher == null) {
            return null;
        }
        DocValuesCollector.LongValuesIterator ranges = this.getRanges();
        int pageSize = Math.min(ranges.remaining(), this.rangesPerPage);
        long[] rangeMap = new long[pageSize * 2];
        for (int i = 0; i < pageSize; ++i) {
            long range;
            rangeMap[i * 2] = range = ranges.next();
            rangeMap[i * 2 + 1] = this.labeledBitmap(ranges);
        }
        if (pageSize < this.rangesPerPage) {
            this.searcher = null;
        }
        return new LongPageIterator((Iterator<long[]>)((Object)new BitmapExtractor(this.format.bitmapFormat(), rangeMap)));
    }

    private DocValuesCollector.LongValuesIterator getRanges() {
        if (this.rangesIterator != null) {
            return this.rangesIterator;
        }
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.searcher.search(this.query, (Collector)docValuesCollector);
            this.rangesIterator = docValuesCollector.getValuesIterator("range");
            return this.rangesIterator;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long labeledBitmap(DocValuesAccess doc) {
        long bitmap = -1L;
        for (int label : this.labels) {
            bitmap &= doc.getValue(this.format.label(label));
        }
        return bitmap;
    }
}

