/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.legacy.CombinedIndexHits;
import org.neo4j.index.impl.lucene.legacy.ConstantScoreIterator;
import org.neo4j.index.impl.lucene.legacy.DocToIdIterator;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexReference;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.LuceneTransactionState;
import org.neo4j.index.impl.lucene.legacy.TopDocsIterator;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.spi.legacyindex.IndexCommandFactory;

public abstract class LuceneLegacyIndex
implements LegacyIndex {
    static final String KEY_DOC_ID = "_id_";
    static final String KEY_START_NODE_ID = "_start_node_id_";
    static final String KEY_END_NODE_ID = "_end_node_id_";
    private static Set<String> FORBIDDEN_KEYS = new HashSet<String>(Arrays.asList(null, "_id_", "_start_node_id_", "_end_node_id_"));
    protected final IndexIdentifier identifier;
    final IndexType type;
    protected final LuceneTransactionState transaction;
    private final LuceneDataSource dataSource;
    protected final IndexCommandFactory commandFactory;

    LuceneLegacyIndex(LuceneDataSource dataSource, IndexIdentifier identifier, LuceneTransactionState transaction, IndexType type, IndexCommandFactory commandFactory) {
        this.dataSource = dataSource;
        this.identifier = identifier;
        this.transaction = transaction;
        this.type = type;
        this.commandFactory = commandFactory;
    }

    public void addNode(long entityId, String key, Object value) {
        LuceneLegacyIndex.assertValidKey(key);
        EntityId.IdData entity = new EntityId.IdData(entityId);
        for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
            oneValue = this.getCorrectValue(oneValue);
            this.transaction.add(this, entity, key, oneValue);
            this.commandFactory.addNode(this.identifier.indexName, entityId, key, oneValue);
        }
    }

    protected Object getCorrectValue(Object value) {
        if (value instanceof ValueContext) {
            return ((ValueContext)value).getCorrectValue();
        }
        return value.toString();
    }

    private static void assertValidKey(String key) {
        if (FORBIDDEN_KEYS.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " forbidden");
        }
    }

    public void remove(long entityId, String key, Object value) {
        LuceneLegacyIndex.assertValidKey(key);
        EntityId.IdData entity = new EntityId.IdData(entityId);
        for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
            oneValue = this.getCorrectValue(oneValue);
            this.transaction.remove(this, entity, key, oneValue);
            this.addRemoveCommand(entityId, key, oneValue);
        }
    }

    public void remove(long entityId, String key) {
        LuceneLegacyIndex.assertValidKey(key);
        EntityId.IdData entity = new EntityId.IdData(entityId);
        this.transaction.remove(this, entity, key);
        this.addRemoveCommand(entityId, key, null);
    }

    public void remove(long entityId) {
        EntityId.IdData entity = new EntityId.IdData(entityId);
        this.transaction.remove(this, entity);
        this.addRemoveCommand(entityId, null, null);
    }

    public void drop() {
        this.transaction.delete(this);
    }

    public LegacyIndexHits get(String key, Object value) {
        return this.query(this.type.get(key, value), key, value, null);
    }

    public LegacyIndexHits query(String key, Object queryOrQueryObject) {
        QueryContext context = queryOrQueryObject instanceof QueryContext ? (QueryContext)queryOrQueryObject : null;
        return this.query(this.type.query(key, context != null ? context.getQueryOrQueryObject() : queryOrQueryObject, context), null, null, context);
    }

    public LegacyIndexHits query(Object queryOrQueryObject) {
        return this.query(null, queryOrQueryObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LegacyIndexHits query(Query query, String keyForDirectLookup, Object valueForDirectLookup, QueryContext additionalParametersOrNull) {
        ArrayList<EntityId> simpleTransactionStateIds = new ArrayList<EntityId>();
        Set<EntityId> removedIdsFromTransactionState = Collections.emptySet();
        IndexSearcher fulltextTransactionStateSearcher = null;
        if (this.transaction != null) {
            if (keyForDirectLookup != null) {
                simpleTransactionStateIds.addAll(this.transaction.getAddedIds(this, keyForDirectLookup, valueForDirectLookup));
            } else {
                fulltextTransactionStateSearcher = this.transaction.getAdditionsAsSearcher(this, additionalParametersOrNull);
            }
            removedIdsFromTransactionState = keyForDirectLookup != null ? this.transaction.getRemovedIds(this, keyForDirectLookup, valueForDirectLookup) : this.transaction.getRemovedIds(this, query);
        }
        ConstantScoreIterator idIterator = null;
        IndexReference searcher = null;
        this.dataSource.getReadLock();
        try {
            searcher = this.dataSource.getIndexSearcher(this.identifier);
        }
        finally {
            this.dataSource.releaseReadLock();
        }
        if (searcher != null) {
            try {
                PrimitiveLongSet idsModifiedInTransactionState = this.gatherIdsModifiedInTransactionState(simpleTransactionStateIds, fulltextTransactionStateSearcher, query);
                DocToIdIterator hits = new DocToIdIterator(this.search(searcher, fulltextTransactionStateSearcher, query, additionalParametersOrNull, removedIdsFromTransactionState), removedIdsFromTransactionState, searcher, idsModifiedInTransactionState);
                idIterator = simpleTransactionStateIds.isEmpty() ? hits : new CombinedIndexHits(Arrays.asList(new LegacyIndexHits[]{hits, new ConstantScoreIterator(simpleTransactionStateIds, Float.NaN)}));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to query " + this + " with " + query, e);
            }
        }
        idIterator = idIterator == null ? new ConstantScoreIterator(simpleTransactionStateIds, 0.0f) : idIterator;
        return idIterator;
    }

    private PrimitiveLongSet gatherIdsModifiedInTransactionState(List<EntityId> simpleTransactionStateIds, IndexSearcher fulltextTransactionStateSearcher, Query query) throws IOException {
        if (simpleTransactionStateIds.isEmpty() && fulltextTransactionStateSearcher == null) {
            return PrimitiveLongCollections.emptySet();
        }
        DocValuesCollector docValuesCollector = null;
        int fulltextSize = 0;
        if (fulltextTransactionStateSearcher != null) {
            docValuesCollector = new DocValuesCollector();
            fulltextTransactionStateSearcher.search(query, (Collector)docValuesCollector);
            fulltextSize = docValuesCollector.getTotalHits();
            if (simpleTransactionStateIds.isEmpty() && fulltextSize == 0) {
                return PrimitiveLongCollections.emptySet();
            }
        }
        PrimitiveLongSet set = Primitive.longSet((int)(simpleTransactionStateIds.size() + fulltextSize));
        for (EntityId id : simpleTransactionStateIds) {
            set.add(id.id());
        }
        if (docValuesCollector != null) {
            DocValuesCollector.LongValuesIterator valuesIterator = docValuesCollector.getValuesIterator(KEY_DOC_ID);
            while (valuesIterator.hasNext()) {
                set.add(valuesIterator.next());
            }
        }
        return set;
    }

    private IndexHits<Document> search(IndexReference searcherRef, IndexSearcher fulltextTransactionStateSearcher, Query query, QueryContext additionalParametersOrNull, Collection<EntityId> removed) throws IOException {
        IndexSearcher searcher;
        if (fulltextTransactionStateSearcher != null && !removed.isEmpty()) {
            this.letThroughAdditions(fulltextTransactionStateSearcher, query, removed);
        }
        IndexSearcher indexSearcher = searcher = fulltextTransactionStateSearcher == null ? searcherRef.getSearcher() : new IndexSearcher((IndexReader)new MultiReader(new IndexReader[]{searcherRef.getSearcher().getIndexReader(), fulltextTransactionStateSearcher.getIndexReader()}));
        if (additionalParametersOrNull == null || additionalParametersOrNull.getTop() <= 0) {
            Sort sorting = additionalParametersOrNull != null ? additionalParametersOrNull.getSorting() : null;
            boolean forceScore = additionalParametersOrNull == null || !additionalParametersOrNull.getTradeCorrectnessForSpeed();
            DocValuesCollector collector = new DocValuesCollector(forceScore);
            searcher.search(query, (Collector)collector);
            return collector.getIndexHits(sorting);
        }
        TopDocsIterator result = new TopDocsIterator(query, additionalParametersOrNull, searcher);
        return result;
    }

    private void letThroughAdditions(IndexSearcher additionsSearcher, Query query, Collection<EntityId> removed) throws IOException {
        DocValuesCollector collector = new DocValuesCollector(false);
        additionsSearcher.search(query, (Collector)collector);
        DocValuesCollector.LongValuesIterator valuesIterator = collector.getValuesIterator(KEY_DOC_ID);
        EntityId.LongCostume id = new EntityId.LongCostume();
        while (valuesIterator.hasNext()) {
            long value = valuesIterator.next();
            removed.remove(id.setId(value));
        }
    }

    IndexIdentifier getIdentifier() {
        return this.identifier;
    }

    protected abstract void addRemoveCommand(long var1, String var3, Object var4);

    static class RelationshipLegacyIndex
    extends LuceneLegacyIndex {
        RelationshipLegacyIndex(LuceneDataSource dataSource, IndexIdentifier identifier, LuceneTransactionState transaction, IndexType type, IndexCommandFactory commandFactory) {
            super(dataSource, identifier, transaction, type, commandFactory);
        }

        public void addRelationship(long entityId, String key, Object value, long startNode, long endNode) {
            LuceneLegacyIndex.assertValidKey(key);
            EntityId.RelationshipData entity = new EntityId.RelationshipData(entityId, startNode, endNode);
            for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
                oneValue = this.getCorrectValue(oneValue);
                this.transaction.add(this, entity, key, oneValue);
                this.commandFactory.addRelationship(this.identifier.indexName, entityId, key, oneValue, startNode, endNode);
            }
        }

        public LegacyIndexHits get(String key, Object valueOrNull, long startNode, long endNode) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            if (key != null && valueOrNull != null) {
                builder.add(this.type.get(key, valueOrNull), BooleanClause.Occur.MUST);
            }
            RelationshipLegacyIndex.addIfAssigned(builder, startNode, LuceneLegacyIndex.KEY_START_NODE_ID);
            RelationshipLegacyIndex.addIfAssigned(builder, endNode, LuceneLegacyIndex.KEY_END_NODE_ID);
            return this.query((Query)builder.build(), null, null, null);
        }

        @Override
        protected void addRemoveCommand(long entity, String key, Object value) {
            this.commandFactory.removeRelationship(this.identifier.indexName, entity, key, value);
        }

        public LegacyIndexHits query(String key, Object queryOrQueryObjectOrNull, long startNode, long endNode) {
            QueryContext context = queryOrQueryObjectOrNull != null && queryOrQueryObjectOrNull instanceof QueryContext ? (QueryContext)queryOrQueryObjectOrNull : null;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            if (context != null && context.getQueryOrQueryObject() != null || context == null && queryOrQueryObjectOrNull != null) {
                builder.add(this.type.query(key, context != null ? context.getQueryOrQueryObject() : queryOrQueryObjectOrNull, context), BooleanClause.Occur.MUST);
            }
            RelationshipLegacyIndex.addIfAssigned(builder, startNode, LuceneLegacyIndex.KEY_START_NODE_ID);
            RelationshipLegacyIndex.addIfAssigned(builder, endNode, LuceneLegacyIndex.KEY_END_NODE_ID);
            return this.query((Query)builder.build(), null, null, context);
        }

        public void removeRelationship(long entityId, String key, Object value, long startNode, long endNode) {
            LuceneLegacyIndex.assertValidKey(key);
            EntityId.RelationshipData entity = new EntityId.RelationshipData(entityId, startNode, endNode);
            for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
                oneValue = this.getCorrectValue(oneValue);
                this.transaction.remove(this, entity, key, oneValue);
                this.addRemoveCommand(entityId, key, oneValue);
            }
        }

        public void removeRelationship(long entityId, String key, long startNode, long endNode) {
            LuceneLegacyIndex.assertValidKey(key);
            EntityId.RelationshipData entity = new EntityId.RelationshipData(entityId, startNode, endNode);
            this.transaction.remove(this, entity, key);
            this.addRemoveCommand(entityId, key, null);
        }

        public void removeRelationship(long entityId, long startNode, long endNode) {
            EntityId.RelationshipData entity = new EntityId.RelationshipData(entityId, startNode, endNode);
            this.transaction.remove(this, entity);
            this.addRemoveCommand(entityId, null, null);
        }

        private static void addIfAssigned(BooleanQuery.Builder builder, long node, String field) {
            if (node != -1L) {
                builder.add((Query)new TermQuery(new Term(field, "" + node)), BooleanClause.Occur.MUST);
            }
        }

        public LegacyIndexHits query(Object queryOrQueryObjectOrNull, long startNode, long endNode) {
            return this.query(null, queryOrQueryObjectOrNull, startNode, endNode);
        }
    }

    static class NodeLegacyIndex
    extends LuceneLegacyIndex {
        NodeLegacyIndex(LuceneDataSource dataSource, IndexIdentifier identifier, LuceneTransactionState transaction, IndexType type, IndexCommandFactory commandFactory) {
            super(dataSource, identifier, transaction, type, commandFactory);
        }

        public LegacyIndexHits get(String key, Object value, long startNode, long endNode) {
            throw new UnsupportedOperationException();
        }

        public LegacyIndexHits query(String key, Object queryOrQueryObject, long startNode, long endNode) {
            throw new UnsupportedOperationException();
        }

        public LegacyIndexHits query(Object queryOrQueryObject, long startNode, long endNode) {
            throw new UnsupportedOperationException();
        }

        public void addRelationship(long entity, String key, Object value, long startNode, long endNode) {
            throw new UnsupportedOperationException();
        }

        public void removeRelationship(long entity, String key, Object value, long startNode, long endNode) {
            throw new UnsupportedOperationException();
        }

        public void removeRelationship(long entity, String key, long startNode, long endNode) {
            throw new UnsupportedOperationException();
        }

        public void removeRelationship(long entity, long startNode, long endNode) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void addRemoveCommand(long entity, String key, Object value) {
            this.commandFactory.removeNode(this.identifier.indexName, entity, key, value);
        }
    }
}

