/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;

public final class IndexSample {
    private final long indexSize;
    private final long uniqueValues;
    private final long sampleSize;
    private final long updates;

    public IndexSample() {
        this(0L, 0L, 0L);
    }

    public IndexSample(long indexSize, long uniqueValues, long sampleSize) {
        this(indexSize, uniqueValues, sampleSize, 0L);
    }

    public IndexSample(long indexSize, long uniqueValues, long sampleSize, long updates) {
        this.indexSize = indexSize;
        this.uniqueValues = uniqueValues;
        this.sampleSize = sampleSize;
        this.updates = updates;
    }

    public long indexSize() {
        return this.indexSize;
    }

    public long uniqueValues() {
        return this.uniqueValues;
    }

    public long sampleSize() {
        return this.sampleSize;
    }

    public long updates() {
        return this.updates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSample that = (IndexSample)o;
        return this.indexSize == that.indexSize && this.uniqueValues == that.uniqueValues && this.sampleSize == that.sampleSize && this.updates == that.updates;
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.indexSize, this.uniqueValues, this.sampleSize, this.updates});
    }

    public String toString() {
        return "IndexSample{indexSize=" + this.indexSize + ", uniqueValues=" + this.uniqueValues + ", sampleSize=" + this.sampleSize + ", updates=" + this.updates + "}";
    }
}

