/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.common.Subject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;

public interface AuthSubject {
    public static final AuthSubject ANONYMOUS = new AuthSubject(){

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.FAILURE;
        }

        @Override
        public boolean hasUsername(String username) {
            return false;
        }

        @Override
        public String executingUser() {
            return "";
        }
    };
    public static final AuthSubject AUTH_DISABLED = new AuthSubject(){

        @Override
        public String executingUser() {
            return "";
        }

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.SUCCESS;
        }

        @Override
        public boolean hasUsername(String username) {
            return false;
        }
    };

    public AuthenticationResult getAuthenticationResult();

    public boolean hasUsername(String var1);

    public String executingUser();

    default public String authenticatedUser() {
        return this.executingUser();
    }

    default public Subject userSubject() {
        if (AUTH_DISABLED == this) {
            return Subject.AUTH_DISABLED;
        }
        if (ANONYMOUS == this) {
            return Subject.ANONYMOUS;
        }
        return new Subject(this.executingUser());
    }
}

