/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.EvaluationContext;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.path.AStar;
import org.neo4j.graphalgo.impl.path.AllPaths;
import org.neo4j.graphalgo.impl.path.AllSimplePaths;
import org.neo4j.graphalgo.impl.path.Dijkstra;
import org.neo4j.graphalgo.impl.path.DijkstraBidirectional;
import org.neo4j.graphalgo.impl.path.ExactDepthPathFinder;
import org.neo4j.graphalgo.impl.path.ShortestPath;
import org.neo4j.graphalgo.impl.util.DoubleEvaluator;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;

@PublicApi
public abstract class GraphAlgoFactory {
    public static PathFinder<Path> allPaths(EvaluationContext context, PathExpander expander, int maxDepth) {
        return new AllPaths(context, maxDepth, expander);
    }

    public static PathFinder<Path> allSimplePaths(EvaluationContext context, PathExpander expander, int maxDepth) {
        return new AllSimplePaths(context, maxDepth, expander);
    }

    public static PathFinder<Path> shortestPath(EvaluationContext context, PathExpander expander, int maxDepth) {
        return new ShortestPath(context, maxDepth, expander);
    }

    public static PathFinder<Path> shortestPath(EvaluationContext context, PathExpander expander, int maxDepth, int maxHitCount) {
        return new ShortestPath(context, maxDepth, expander, maxHitCount);
    }

    public static PathFinder<Path> pathsWithLength(EvaluationContext context, PathExpander expander, int length) {
        return new ExactDepthPathFinder(context, expander, length, Integer.MAX_VALUE, false);
    }

    public static PathFinder<WeightedPath> aStar(EvaluationContext context, PathExpander expander, CostEvaluator<Double> lengthEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        return new AStar(context, expander, lengthEvaluator, estimateEvaluator);
    }

    public static PathFinder<WeightedPath> dijkstra(EvaluationContext context, PathExpander<Double> expander, CostEvaluator<Double> costEvaluator) {
        return new DijkstraBidirectional(context, expander, costEvaluator, 1.0E-8);
    }

    public static PathFinder<WeightedPath> dijkstra(EvaluationContext context, PathExpander<Double> expander, String relationshipPropertyRepresentingCost) {
        return GraphAlgoFactory.dijkstra(context, expander, new DoubleEvaluator(relationshipPropertyRepresentingCost));
    }

    public static PathFinder<WeightedPath> dijkstra(PathExpander<Double> expander, String relationshipPropertyRepresentingCost, int numberOfWantedPaths) {
        return GraphAlgoFactory.dijkstra(expander, new DoubleEvaluator(relationshipPropertyRepresentingCost), numberOfWantedPaths);
    }

    public static PathFinder<WeightedPath> dijkstra(PathExpander<Double> expander, CostEvaluator<Double> costEvaluator, int numberOfWantedPaths) {
        return new Dijkstra(expander, costEvaluator, 1.0E-8, PathInterestFactory.numberOfShortest(1.0E-8, numberOfWantedPaths));
    }
}

