/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.util.Properties;
import org.bytedeco.javacpp.Loader;
import org.nd4j.context.Nd4jContext;
import org.nd4j.nativeblas.NativeOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOpsHolder {
    private static Logger log = LoggerFactory.getLogger(NativeOpsHolder.class);
    private static final NativeOpsHolder INSTANCE = new NativeOpsHolder();
    private final NativeOps deviceNativeOps;

    public static int getCores(int totals) {
        if (totals >= 256) {
            return 64;
        }
        int ht_off = totals / 2;
        if (ht_off <= 4) {
            return 4;
        }
        if (ht_off > 24) {
            int rounds = 0;
            while (ht_off > 24) {
                if (ht_off <= 24) continue;
                ht_off /= 2;
                ++rounds;
            }
            if (ht_off == 20 && rounds < 2) {
                ht_off /= 2;
            }
        } else {
            if (ht_off <= 6) {
                return ht_off;
            }
            if (NativeOpsHolder.isOdd(ht_off)) {
                return ht_off;
            }
            if (ht_off == 20 || ht_off == 16) {
                ht_off /= 2;
            }
        }
        return ht_off;
    }

    private static boolean isOdd(int value) {
        return value % 2 != 0;
    }

    private NativeOpsHolder() {
        try {
            Properties props = Nd4jContext.getInstance().getConf();
            String name = System.getProperty("native.ops", props.get("native.ops").toString());
            Class<NativeOps> nativeOpsClazz = Class.forName(name).asSubclass(NativeOps.class);
            this.deviceNativeOps = nativeOpsClazz.newInstance();
            this.deviceNativeOps.initializeDevicesAndFunctions();
            String numThreadsString = System.getenv("OMP_NUM_THREADS");
            if (numThreadsString != null && !numThreadsString.isEmpty()) {
                int numThreads = Integer.parseInt(numThreadsString);
                this.deviceNativeOps.setOmpNumThreads(numThreads);
            } else {
                int cores = Loader.totalCores();
                int chips = Loader.totalChips();
                if (chips > 0 && cores > 0) {
                    this.deviceNativeOps.setOmpNumThreads(Math.max(1, cores / chips));
                } else {
                    this.deviceNativeOps.setOmpNumThreads(NativeOpsHolder.getCores(Runtime.getRuntime().availableProcessors()));
                }
            }
            String logInitProperty = System.getProperty("org.nd4j.log.initialization", "true");
            boolean logInit = Boolean.parseBoolean(logInitProperty);
            if (logInit) {
                log.info("Number of threads used for linear algebra: {}", (Object)this.deviceNativeOps.ompGetMaxThreads());
            }
        }
        catch (Error | Exception e) {
            throw new RuntimeException("ND4J is probably missing dependencies. For more information, please refer to: http://nd4j.org/getstarted.html", e);
        }
    }

    public static NativeOpsHolder getInstance() {
        return INSTANCE;
    }

    public NativeOps getDeviceNativeOps() {
        return this.deviceNativeOps;
    }
}

