/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.util.Rational;

class Bernoulli {
    static List<Rational> a = new ArrayList<Rational>();

    public Bernoulli() {
        if (a.isEmpty()) {
            a.add(Rational.ONE);
            a.add(new Rational(1, 6));
        }
    }

    protected void set(int n, Rational value) {
        int nindx = n / 2;
        if (nindx < a.size()) {
            a.set(nindx, value);
        } else {
            while (a.size() < nindx) {
                a.add(Rational.ZERO);
            }
            a.add(value);
        }
    }

    public Rational at(int n) {
        if (n == 1) {
            return new Rational(-1, 2);
        }
        if (n % 2 != 0) {
            return Rational.ZERO;
        }
        int nindx = n / 2;
        if (a.size() <= nindx) {
            for (int i = 2 * a.size(); i <= n; i += 2) {
                this.set(i, this.doubleSum(i));
            }
        }
        return a.get(nindx);
    }

    private Rational doubleSum(int n) {
        Rational resul = Rational.ZERO;
        for (int k = 0; k <= n; ++k) {
            Rational jsum = Rational.ZERO;
            BigInteger bin = BigInteger.ONE;
            for (int j = 0; j <= k; ++j) {
                BigInteger jpown = BigInteger.valueOf(j).pow(n);
                jsum = j % 2 == 0 ? jsum.add(bin.multiply(jpown)) : jsum.subtract(bin.multiply(jpown));
                bin = bin.multiply(BigInteger.valueOf(k - j)).divide(BigInteger.valueOf(j + 1));
            }
            resul = resul.add(jsum.divide(BigInteger.valueOf(k + 1)));
        }
        return resul;
    }
}

