/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.locations;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.internal.com.google.common.base.Function;
import org.mutabilitydetector.locations.ClassName;
import org.mutabilitydetector.locations.ClassNameConverter;
import org.mutabilitydetector.locations.Slashed;

@Immutable
public final class Dotted
extends ClassName {
    public static final Function<String, Dotted> STRING_NAME_TO_DOTTED = new Function<String, Dotted>(){

        @Override
        public Dotted apply(@Nonnull String className) {
            return Dotted.dotted(className);
        }
    };
    public static final Function<Class<?>, Dotted> CLASS_TO_DOTTED = new Function<Class<?>, Dotted>(){

        @Override
        public Dotted apply(@Nonnull Class<?> clazz) {
            return Dotted.fromClass(clazz);
        }
    };
    public static final Function<Dotted, String> AS_SIMPLE_STRING = new Function<Dotted, String>(){

        @Override
        @Nullable
        public String apply(Dotted input) {
            return input.asSimpleString();
        }
    };

    private Dotted(String className) {
        super(className);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dotted other = (Dotted)obj;
        return this.asString().equals(other.asString());
    }

    @Override
    public int hashCode() {
        return this.asString().hashCode();
    }

    public static Dotted dotted(String className) {
        return new Dotted(new ClassNameConverter().dotted(className));
    }

    public static Dotted fromSlashed(Slashed className) {
        String converted = new ClassNameConverter().dotted(className.asString());
        return Dotted.dotted(converted);
    }

    public static Dotted fromSlashedString(String className) {
        String dottedClassNameString = new ClassNameConverter().dotted(className);
        return Dotted.dotted(dottedClassNameString);
    }

    public static Dotted fromClass(Class<?> clazz) {
        return Dotted.dotted(clazz.getName());
    }
}

