/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.cli;

import java.net.URLClassLoader;
import org.mutabilitydetector.classloading.AnalysisClassLoader;
import org.mutabilitydetector.classloading.ClassForNameWrapper;

public final class URLFallbackClassLoader
implements AnalysisClassLoader {
    private final URLClassLoader urlClassLoader;
    private final ClassForNameWrapper classForNameWrapper;

    public URLFallbackClassLoader(URLClassLoader urlClassLoader, ClassForNameWrapper classForNameWrapper) {
        this.urlClassLoader = urlClassLoader;
        this.classForNameWrapper = classForNameWrapper;
    }

    @Override
    public Class<?> loadClass(String dottedClass) throws ClassNotFoundException {
        Class<?> toReturn;
        try {
            toReturn = this.urlClassLoader.loadClass(dottedClass);
        }
        catch (ClassNotFoundException e) {
            toReturn = this.classForNameWrapper.loadClass(dottedClass);
        }
        return toReturn;
    }
}

