/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.mutabilitydetector.AnalysisSession;
import org.mutabilitydetector.Configuration;
import org.mutabilitydetector.ConfigurationBuilder;
import org.mutabilitydetector.Configurations;
import org.mutabilitydetector.DefaultCachingAnalysisSession;
import org.mutabilitydetector.asmoverride.ClassLoadingVerifierFactory;
import org.mutabilitydetector.checkers.CheckerRunner;
import org.mutabilitydetector.checkers.ClassPathBasedCheckerRunnerFactory;
import org.mutabilitydetector.checkers.MutabilityCheckerFactory;
import org.mutabilitydetector.classloading.CachingAnalysisClassLoader;
import org.mutabilitydetector.classloading.ClassForNameWrapper;
import org.mutabilitydetector.cli.BatchAnalysisOptions;
import org.mutabilitydetector.cli.BatchAnalysisSession;
import org.mutabilitydetector.cli.ClassListReaderFactory;
import org.mutabilitydetector.cli.CommandLineOptions;
import org.mutabilitydetector.cli.NamesFromClassResources;
import org.mutabilitydetector.cli.SessionResultsFormatter;
import org.mutabilitydetector.cli.URLFallbackClassLoader;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.com.google.classpath.ClassPathFactory;
import org.mutabilitydetector.internal.com.google.classpath.RegExpResourceFilter;
import org.mutabilitydetector.locations.Dotted;

public final class RunMutabilityDetector
implements Runnable,
Callable<String> {
    private final ClassPath classpath;
    private final BatchAnalysisOptions options;
    private final NamesFromClassResources namesFromClassResources;

    public RunMutabilityDetector(ClassPath classpath, BatchAnalysisOptions options, NamesFromClassResources namesFromClassResources) {
        this.classpath = classpath;
        this.options = options;
        this.namesFromClassResources = namesFromClassResources;
    }

    @Override
    public void run() {
        StringBuilder output = this.getResultString();
        System.out.println(output);
    }

    @Override
    public String call() throws Exception {
        return this.getResultString().toString();
    }

    private StringBuilder getResultString() {
        RegExpResourceFilter regExpResourceFilter = new RegExpResourceFilter(".*", ".*\\.class");
        String[] findResources = this.classpath.findResources("", regExpResourceFilter);
        Configuration configuration = new ConfigurationBuilder(){

            @Override
            public void configure() {
                this.mergeHardcodedResultsFrom(Configurations.OUT_OF_THE_BOX_CONFIGURATION);
                this.setExceptionPolicy(RunMutabilityDetector.this.options.failFast() ? CheckerRunner.ExceptionPolicy.FAIL_FAST : CheckerRunner.ExceptionPolicy.CARRY_ON);
            }
        }.build();
        String[] classPathFiles = new ClassPathFactory().parseClasspath(this.options.classpath());
        ClassLoadingVerifierFactory verifierFactory = this.createClassLoadingVerifierFactory(classPathFiles);
        AnalysisSession newSession = DefaultCachingAnalysisSession.createWithGivenClassPath(this.classpath, new ClassPathBasedCheckerRunnerFactory(this.classpath, configuration.exceptionPolicy()), new MutabilityCheckerFactory(MutabilityCheckerFactory.ReassignedFieldAnalysisChoice.NAIVE_PUT_FIELD_ANALYSIS, configuration.immutableContainerClasses()), verifierFactory, configuration);
        List<Dotted> filtered = this.namesFromClassResources.asDotted(findResources);
        AnalysisSession completedSession = new BatchAnalysisSession(newSession).runAnalysis(filtered);
        ClassListReaderFactory readerFactory = new ClassListReaderFactory(this.options.classListFile());
        return new SessionResultsFormatter(this.options, readerFactory).format(completedSession.getResults(), completedSession.getErrors());
    }

    private ClassLoadingVerifierFactory createClassLoadingVerifierFactory(String[] classPathFiles) {
        return new ClassLoadingVerifierFactory(new CachingAnalysisClassLoader(new URLFallbackClassLoader(this.getCustomClassLoader(classPathFiles), new ClassForNameWrapper())));
    }

    private URLClassLoader getCustomClassLoader(String[] classPathFiles) {
        ArrayList<URL> urlList = new ArrayList<URL>(classPathFiles.length);
        for (String classPathUrl : classPathFiles) {
            try {
                URL toAdd = new File(classPathUrl).toURI().toURL();
                urlList.add(toAdd);
            }
            catch (MalformedURLException e) {
                System.err.printf("Classpath option %s is invalid.", classPathUrl);
            }
        }
        return new URLClassLoader(urlList.toArray(new URL[urlList.size()]));
    }

    public static void main(String[] args) {
        BatchAnalysisOptions options = RunMutabilityDetector.createOptionsFromArgs(args);
        ClassPath classpath = new ClassPathFactory().createFromPath(options.classpath());
        new RunMutabilityDetector(classpath, options, new NamesFromClassResources(options.match())).run();
    }

    private static BatchAnalysisOptions createOptionsFromArgs(String[] args) {
        try {
            return new CommandLineOptions(System.err, args);
        }
        catch (Throwable e) {
            System.out.println("Exiting...");
            System.exit(1);
            return null;
        }
    }
}

