/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.List;
import java.util.SortedSet;
import org.mutabilitydetector.checkers.settermethod.AbstractSetterMethodChecker;
import org.mutabilitydetector.checkers.settermethod.Alias;
import org.mutabilitydetector.checkers.settermethod.AliasFinder;
import org.mutabilitydetector.checkers.settermethod.AssignmentInsn;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.EnhancedClassNode;
import org.mutabilitydetector.checkers.settermethod.Opcode;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.VarInsnNode;

final class EffectiveAssignmentInsnVerifier {
    private final AssignmentInsn effectiveAssignmentInstruction;
    private final FieldNode candidate;
    private final AbstractSetterMethodChecker setterMethodChecker;

    private EffectiveAssignmentInsnVerifier(AssignmentInsn theAssignmentInsn, FieldNode theCandidate, AbstractSetterMethodChecker theSetterMethodChecker) {
        this.effectiveAssignmentInstruction = theAssignmentInsn;
        this.candidate = theCandidate;
        this.setterMethodChecker = theSetterMethodChecker;
    }

    public static EffectiveAssignmentInsnVerifier newInstance(AssignmentInsn assignmentInsn, FieldNode candidate, AbstractSetterMethodChecker setterMethodChecker) {
        return new EffectiveAssignmentInsnVerifier(Preconditions.checkNotNull(assignmentInsn), Preconditions.checkNotNull(candidate), Preconditions.checkNotNull(setterMethodChecker));
    }

    public void verify() {
        if (this.effectiveAssignmentInstruction.isNull()) {
            return;
        }
        Alias alias = this.findAlias();
        AbstractInsnNode p = this.getPredecessorOfAssignmentInstruction();
        if (alias.doesExist) {
            this.verifyWithAlias(p, alias.localVariable);
        } else {
            this.recognizeAsMutableIfNecessary(p);
        }
    }

    private Alias findAlias() {
        String nameOfAssignedVariable = this.effectiveAssignmentInstruction.getNameOfAssignedVariable();
        ControlFlowBlock surroundingBlock = this.effectiveAssignmentInstruction.getSurroundingControlFlowBlock();
        AliasFinder f = AliasFinder.newInstance(nameOfAssignedVariable, surroundingBlock);
        return (Alias)f.find();
    }

    private AbstractInsnNode getPredecessorOfAssignmentInstruction() {
        ControlFlowBlock surroundingBlock = this.effectiveAssignmentInstruction.getSurroundingControlFlowBlock();
        int indexWithinMethod = this.effectiveAssignmentInstruction.getIndexWithinMethod();
        int predecessorIndexWithinMethod = indexWithinMethod - 1;
        int predecessorIndexWithinBlock = surroundingBlock.getIndexWithinBlock(predecessorIndexWithinMethod);
        return surroundingBlock.getBlockInstructionForIndex(predecessorIndexWithinBlock);
    }

    private void verifyWithAlias(AbstractInsnNode p, int aliasLocalVariable) {
        if (EffectiveAssignmentInsnVerifier.isAliasLoadInstruction(p, aliasLocalVariable)) {
            ControlFlowBlock block = this.effectiveAssignmentInstruction.getSurroundingControlFlowBlock();
            for (ControlFlowBlock predecessorBlock : block.getPredecessors()) {
                this.verifyWithAliasForEachBlock(aliasLocalVariable, predecessorBlock);
            }
        }
    }

    private static boolean isAliasLoadInstruction(AbstractInsnNode insn, int aliasLocalVariable) {
        switch (insn.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                VarInsnNode varInsnNode = (VarInsnNode)insn;
                return aliasLocalVariable == varInsnNode.var;
            }
        }
        return false;
    }

    private void verifyWithAliasForEachBlock(int aliasLocalVariable, ControlFlowBlock predecessorBlock) {
        List<AbstractInsnNode> blockInstructions = predecessorBlock.getBlockInstructions();
        for (int i = 0; i < blockInstructions.size(); ++i) {
            AbstractInsnNode insn = blockInstructions.get(i);
            if (!EffectiveAssignmentInsnVerifier.isAliasStoreInstruction(insn, aliasLocalVariable)) continue;
            AbstractInsnNode predecessor = blockInstructions.get(i - 1);
            this.recognizeAsMutableIfNecessary(predecessor);
            break;
        }
    }

    private static boolean isAliasStoreInstruction(AbstractInsnNode insn, int aliasLocalVariable) {
        switch (insn.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                VarInsnNode varInsnNode = (VarInsnNode)insn;
                return aliasLocalVariable == varInsnNode.var;
            }
        }
        return false;
    }

    private void recognizeAsMutableIfNecessary(AbstractInsnNode p) {
        if (this.isNotPushConstantOntoStackInstruction(p) && this.isNotInvokationOfParameterlessInstanceOrClassMethod(p)) {
            String candidateName = this.effectiveAssignmentInstruction.getNameOfAssignedVariable();
            if (this.isCandidateOfPrimitiveType()) {
                String msgTemplate = "Value for lazy field [%s] is not a constant but stems from a method which is neither parameterless nor an instance or class method.";
                this.setterMethodChecker.setFieldCanBeReassignedResult(String.format("Value for lazy field [%s] is not a constant but stems from a method which is neither parameterless nor an instance or class method.", candidateName));
            } else {
                String message = "Value for lazy field is not a constant but stems from a method which is neither parameterless nor an instance or class method.";
                this.setterMethodChecker.setMutableTypeToFieldResult("Value for lazy field is not a constant but stems from a method which is neither parameterless nor an instance or class method.", candidateName);
            }
        }
    }

    private boolean isNotPushConstantOntoStackInstruction(AbstractInsnNode insn) {
        Opcode opcode = Opcode.forInt(insn.getOpcode());
        SortedSet<Opcode> stackPushingConstants = Opcode.constants();
        return !stackPushingConstants.contains(opcode);
    }

    private boolean isNotInvokationOfParameterlessInstanceOrClassMethod(AbstractInsnNode insn) {
        MethodInsnNode methodInvokationInstruction;
        boolean result = 5 != insn.getType() ? true : EffectiveAssignmentInsnVerifier.hasInvokedMethodArguments(methodInvokationInstruction = (MethodInsnNode)insn) || this.isInvokedMethodNotInstanceOrClassMethod(methodInvokationInstruction);
        return result;
    }

    private static boolean hasInvokedMethodArguments(MethodInsnNode methodInvokationInstruction) {
        String invokedMethodDescriptor = methodInvokationInstruction.desc;
        Type[] argumentTypes = Type.getArgumentTypes(invokedMethodDescriptor);
        return 0 < argumentTypes.length;
    }

    private boolean isInvokedMethodNotInstanceOrClassMethod(MethodInsnNode methodInvokationInstruction) {
        String invokedMethodOwner = methodInvokationInstruction.owner;
        EnhancedClassNode enhancedClassNode = this.setterMethodChecker.getEnhancedClassNode();
        String internalClassName = enhancedClassNode.getName();
        return !invokedMethodOwner.equals(internalClassName);
    }

    private boolean isCandidateOfPrimitiveType() {
        Type typeOfCandidate = Type.getType(this.candidate.desc);
        int sortOfType = typeOfCandidate.getSort();
        return 9 != sortOfType && 11 != sortOfType && 10 != sortOfType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [effectiveAssignmentInstruction=");
        builder.append(this.effectiveAssignmentInstruction);
        builder.append(", candidate=").append(this.candidate.name);
        builder.append(", setterMethodChecker=").append(this.setterMethodChecker);
        builder.append(']');
        return builder.toString();
    }
}

