/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.settermethod.AssignmentInsn;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.DefaultAssignmentInsn;
import org.mutabilitydetector.checkers.settermethod.Finder;
import org.mutabilitydetector.checkers.settermethod.NullAssignmentInsn;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;

@NotThreadSafe
final class EffectiveAssignmentInsnFinder
implements Finder<AssignmentInsn> {
    private final FieldNode targetVariable;
    private final Collection<ControlFlowBlock> controlFlowBlocks;

    private EffectiveAssignmentInsnFinder(FieldNode theTargetVariable, Collection<ControlFlowBlock> theControlFlowBlocks) {
        this.targetVariable = theTargetVariable;
        this.controlFlowBlocks = Collections.unmodifiableCollection(theControlFlowBlocks);
    }

    public static EffectiveAssignmentInsnFinder newInstance(FieldNode targetVariable, Collection<ControlFlowBlock> controlFlowBlocks) {
        return new EffectiveAssignmentInsnFinder(Preconditions.checkNotNull(targetVariable), Preconditions.checkNotNull(controlFlowBlocks));
    }

    @Override
    public AssignmentInsn find() {
        Collection<AssignmentInsn> assignmentInstructions = this.findAssignmentInstructionsForVariable();
        return this.getEffectiveAssignmentInstruction(assignmentInstructions);
    }

    private Collection<AssignmentInsn> findAssignmentInstructionsForVariable() {
        HashSet<AssignmentInsn> result = new HashSet<AssignmentInsn>();
        for (ControlFlowBlock controlFlowBlock : this.controlFlowBlocks) {
            result.addAll(this.findInAllBlockInstructions(controlFlowBlock));
        }
        return result;
    }

    private Collection<AssignmentInsn> findInAllBlockInstructions(ControlFlowBlock controlFlowBlock) {
        HashSet<AssignmentInsn> result = new HashSet<AssignmentInsn>();
        List<AbstractInsnNode> blockInstructions = controlFlowBlock.getBlockInstructions();
        for (int i = 0; i < blockInstructions.size(); ++i) {
            AbstractInsnNode insn = blockInstructions.get(i);
            if (!this.isInitialiserForTargetVariable(insn)) continue;
            FieldInsnNode assignmentInsnNode = (FieldInsnNode)insn;
            int indexWithinMethod = controlFlowBlock.getIndexWithinMethod(i);
            result.add(DefaultAssignmentInsn.newInstance(controlFlowBlock, indexWithinMethod, assignmentInsnNode));
        }
        return result;
    }

    private boolean isInitialiserForTargetVariable(AbstractInsnNode insn) {
        boolean result;
        if (EffectiveAssignmentInsnFinder.isPutfieldInstruction(insn) || EffectiveAssignmentInsnFinder.isPutstaticInstruction(insn)) {
            FieldInsnNode assignmentInsn = (FieldInsnNode)insn;
            result = assignmentInsn.name.equals(this.targetVariable.name);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean isPutfieldInstruction(AbstractInsnNode insn) {
        return 181 == insn.getOpcode();
    }

    private static boolean isPutstaticInstruction(AbstractInsnNode insn) {
        return 179 == insn.getOpcode();
    }

    private AssignmentInsn getEffectiveAssignmentInstruction(Collection<AssignmentInsn> assignmentInstructions) {
        AssignmentInsn result = NullAssignmentInsn.getInstance();
        int maxInstructionNumber = -1;
        for (AssignmentInsn assignmentInsn : assignmentInstructions) {
            int indexOfAssignmentInstruction = assignmentInsn.getIndexWithinMethod();
            if (indexOfAssignmentInstruction <= maxInstructionNumber) continue;
            maxInstructionNumber = indexOfAssignmentInstruction;
            result = assignmentInsn;
        }
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append(" [targetVariable=").append(this.targetVariable.name);
        b.append(", controlFlowBlocks=").append(this.controlFlowBlocks).append(']');
        return b.toString();
    }
}

