/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.settermethod.JumpInsn;
import org.mutabilitydetector.checkers.settermethod.Opcode;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.Label;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.JumpInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LabelNode;

@NotThreadSafe
final class DefaultJumpInsn
implements JumpInsn {
    private final JumpInsnNode jumpInsnNode;
    private final int indexWithinBlock;
    private final int indexWithinMethod;

    private DefaultJumpInsn(JumpInsnNode theJumpInsnNode, int theIndexWithinBlock, int theIndexWithinMethod) {
        this.jumpInsnNode = theJumpInsnNode;
        this.indexWithinBlock = theIndexWithinBlock;
        this.indexWithinMethod = theIndexWithinMethod;
    }

    public static DefaultJumpInsn newInstance(JumpInsnNode jumpInsnNode, int indexWithinBlock, int indexWithinMethod) {
        return new DefaultJumpInsn(Preconditions.checkNotNull(jumpInsnNode), indexWithinBlock, indexWithinMethod);
    }

    @Override
    public JumpInsnNode getJumpInsnNode() {
        return this.jumpInsnNode;
    }

    @Override
    public int getIndexWithinBlock() {
        return this.indexWithinBlock;
    }

    @Override
    public int getIndexWithinMethod() {
        return this.indexWithinMethod;
    }

    @Override
    public Opcode getOpcode() {
        return Opcode.forInt(this.jumpInsnNode.getOpcode());
    }

    @Override
    public boolean isAssignmentGuard() {
        return false;
    }

    @Override
    public int compareTo(JumpInsn o) {
        Integer thisIndexWithinMethod = this.indexWithinMethod;
        Integer otherIndexWithinMethod = o.getIndexWithinMethod();
        return thisIndexWithinMethod.compareTo(otherIndexWithinMethod);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.indexWithinBlock;
        result = 31 * result + this.indexWithinMethod;
        result = 31 * result + this.jumpInsnNode.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultJumpInsn)) {
            return false;
        }
        DefaultJumpInsn other = (DefaultJumpInsn)obj;
        if (this.indexWithinMethod != other.indexWithinMethod) {
            return false;
        }
        return this.jumpInsnNode.equals(other.jumpInsnNode);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        builder.append("jumpInsnNode=").append(DefaultJumpInsn.toString(this.jumpInsnNode));
        builder.append(", indexWithinBlock=").append(this.indexWithinBlock);
        builder.append(", indexWithinMethod=").append(this.indexWithinMethod);
        builder.append(']');
        return builder.toString();
    }

    private static String toString(JumpInsnNode jumpInsnNode) {
        StringBuilder result = new StringBuilder();
        Opcode opcode = Opcode.forInt(jumpInsnNode.getOpcode());
        LabelNode labelNode = jumpInsnNode.label;
        Label label = labelNode.getLabel();
        result.append('[').append(opcode.toString()).append(", label=").append(label).append(']');
        return result.toString();
    }
}

