/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.Reason;
import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.settermethod.CandidatesInitialisersMapping;
import org.mutabilitydetector.checkers.settermethod.EnhancedClassNode;
import org.mutabilitydetector.internal.org.objectweb.asm.AnnotationVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.Attribute;
import org.mutabilitydetector.internal.org.objectweb.asm.ClassVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.FieldVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.MethodVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.ClassNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;
import org.mutabilitydetector.locations.CodeLocation;

@NotThreadSafe
abstract class AbstractSetterMethodChecker
extends AsmMutabilityChecker {
    protected CandidatesInitialisersMapping candidatesInitialisersMapping = CandidatesInitialisersMapping.newInstance();
    private final ClassNode classNode = new ClassNode();
    @GuardedBy(value="this")
    private volatile EnhancedClassNode enhancedClassNode = null;

    public final void accept(ClassVisitor cv) {
        this.classNode.accept(cv);
    }

    @Override
    public final void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classNode.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public final void visitSource(String file, String debug) {
        this.classNode.visitSource(file, debug);
    }

    @Override
    public final void visitOuterClass(String owner, String name, String desc) {
        this.classNode.visitOuterClass(owner, name, desc);
    }

    @Override
    public final AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.classNode.visitAnnotation(desc, visible);
    }

    @Override
    public final void visitAttribute(Attribute attr) {
        this.classNode.visitAttribute(attr);
    }

    @Override
    public final void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.classNode.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public final FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor result = super.visitField(0, null, null, null, null);
        if (AbstractSetterMethodChecker.isCandidate(access)) {
            result = new FieldNode(access, name, desc, signature, value);
            this.candidatesInitialisersMapping.addCandidate((FieldNode)result);
        } else if (AccessModifierQuery.field(access).isNotFinal() && AccessModifierQuery.field(access).isNotStatic()) {
            this.setNonFinalFieldResult(name);
        }
        if (super.visitField(0, null, null, null, null) == result) {
            result = this.classNode.visitField(access, name, desc, signature, value);
        }
        return result;
    }

    private static boolean isCandidate(int access) {
        return AccessModifierQuery.field(access).isPrivate() && AccessModifierQuery.field(access).isNotFinal();
    }

    @Override
    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return this.classNode.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public final void visitEnd() {
        this.classNode.visitEnd();
        this.verify();
    }

    protected final void verify() {
        this.collectInitialisers();
        this.verifyCandidates();
        this.verifyInitialisers();
        this.collectPossibleInitialValues();
        this.verifyPossibleInitialValues();
        this.collectEffectiveAssignmentInstructions();
        this.verifyEffectiveAssignmentInstructions();
        this.collectAssignmentGuards();
        this.verifyAssignmentGuards();
        this.end();
    }

    protected abstract void collectInitialisers();

    protected abstract void verifyCandidates();

    protected abstract void verifyInitialisers();

    protected abstract void collectPossibleInitialValues();

    protected abstract void verifyPossibleInitialValues();

    protected abstract void collectEffectiveAssignmentInstructions();

    protected abstract void verifyEffectiveAssignmentInstructions();

    protected abstract void collectAssignmentGuards();

    protected abstract void verifyAssignmentGuards();

    protected void end() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EnhancedClassNode getEnhancedClassNode() {
        EnhancedClassNode result = this.enhancedClassNode;
        if (null == result) {
            AbstractSetterMethodChecker abstractSetterMethodChecker = this;
            synchronized (abstractSetterMethodChecker) {
                result = this.enhancedClassNode;
                if (null == result) {
                    this.enhancedClassNode = result = EnhancedClassNode.newInstance(this.classNode);
                }
            }
        }
        return result;
    }

    protected void setResultForClass(String message, Reason reason) {
        super.setResult(message, CodeLocation.ClassLocation.fromInternalName(this.classNode.name), reason);
    }

    final void setNonFinalFieldResult(String variableName) {
        String msg = "Field is not final, if shared across threads the Java Memory Model will not guarantee it is initialised before it is read.";
        this.setNonFinalFieldResult("Field is not final, if shared across threads the Java Memory Model will not guarantee it is initialised before it is read.", variableName);
    }

    final void setNonFinalFieldResult(String message, String variableName) {
        CodeLocation.FieldLocation location = CodeLocation.FieldLocation.fieldLocation(variableName, CodeLocation.ClassLocation.fromInternalName(this.ownerClass));
        this.setResult(message, location, MutabilityReason.NON_FINAL_FIELD);
    }

    final void setFieldCanBeReassignedResult(String variableName, String methodName) {
        String msgTemplate = "Field [%s] can be reassigned within method [%s]";
        String msg = String.format("Field [%s] can be reassigned within method [%s]", variableName, methodName);
        this.setFieldCanBeReassignedResult(msg);
    }

    final void setFieldCanBeReassignedResult(String message) {
        this.setResultForClass(message, MutabilityReason.FIELD_CAN_BE_REASSIGNED);
    }

    final void setMutableTypeToFieldResult(String message, String variableName) {
        CodeLocation.FieldLocation location = CodeLocation.FieldLocation.fieldLocation(variableName, CodeLocation.ClassLocation.fromInternalName(this.ownerClass));
        this.setResult(message, location, MutabilityReason.MUTABLE_TYPE_TO_FIELD);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", [candidatesInitialisersMapping=" + this.candidatesInitialisersMapping + ", classNode=" + this.classNode + ", enhancedClassNode=" + this.enhancedClassNode + "]";
    }
}

