/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.info;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.checkers.info.AnalysisInProgress;
import org.mutabilitydetector.internal.com.google.common.base.Joiner;
import org.mutabilitydetector.internal.com.google.common.base.Objects;
import org.mutabilitydetector.internal.com.google.common.base.Optional;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableList;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.locations.Dotted;

public final class CyclicReferences {
    private final Set<CyclicReference> cyclicReferenceCache = Collections.newSetFromMap(new ConcurrentHashMap());

    public Optional<CyclicReference> detectedBetween(Dotted ownerClass, Dotted fieldClass, AnalysisInProgress analysisInProgress) {
        CyclicReference potentialCyclicReference = new CyclicReference(fieldClass, ownerClass);
        if (this.cyclicReferenceCache.contains(potentialCyclicReference)) {
            return Optional.of(potentialCyclicReference);
        }
        if (fieldClass.equals(ownerClass)) {
            this.cyclicReferenceCache.add(potentialCyclicReference);
            return Optional.of(potentialCyclicReference);
        }
        if (analysisInProgress.contains(fieldClass)) {
            CyclicReference cyclicReference = new CyclicReference(analysisInProgress);
            this.cyclicReferenceCache.add(cyclicReference);
            return Optional.of(cyclicReference);
        }
        return Optional.absent();
    }

    public static CyclicReferences newEmptyMutableInstance() {
        return new CyclicReferences();
    }

    @Immutable
    public static final class CyclicReference {
        public final ImmutableList<Dotted> references;

        public CyclicReference(Dotted first, Dotted second) {
            this.references = ImmutableList.of(first, second);
        }

        public CyclicReference(AnalysisInProgress analysisInProgress) {
            this.references = analysisInProgress.inProgress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CyclicReference that = (CyclicReference)o;
            return Objects.equal(ImmutableSet.copyOf(this.references), ImmutableSet.copyOf(that.references));
        }

        public int hashCode() {
            return Objects.hashCode(this.references);
        }

        public String toString() {
            return "CyclicReference{" + Joiner.on(" -> ").join(this.references) + "}";
        }
    }
}

