/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.checkers.MutabilityAnalysisException;
import org.mutabilitydetector.internal.org.objectweb.asm.ClassVisitor;
import org.mutabilitydetector.locations.Dotted;

public final class UnhandledExceptionBuilder {
    private static final String UNHANDLED_ERROR_MESSAGE = String.format("%nAn unhandled error occurred. This is probably my fault, not yours, and I am sorry.%nI'd love to get an opportunity to fix this, please report as an issue at:%n https://github.com/MutabilityDetector/MutabilityDetector/issues/ %nPasting in this error message and stack trace, and if possible, %ninformation about the code causing the error. %nFor example, one of: %n    .class files (preferably with source);%n    compilable .java files; %n    a jar (again preferably with source);%n    or, if your project is open source, information on where I can get the code from%n        (I'm happy to checkout and build your project in order to investigate the error).%n%nApologies, and thank you for using Mutability Detector.%n%n", new Object[0]);

    public MutabilityAnalysisException unhandledException(Throwable cause, Iterable<AnalysisResult> resultsSoFar, ClassVisitor checker, Dotted className) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(String.format("%nAn unhandled error occurred. Please read message at end of this output.%n%n", new Object[0]));
        errorMessage.append(String.format("Class being analysed: %s%n", className.asString()));
        errorMessage.append(String.format("Checker that failed: %s%n", checker.getClass().getSimpleName()));
        errorMessage.append(String.format("Classes analysed so far:%n", new Object[0]));
        this.appendClassesAnalysed(errorMessage, resultsSoFar);
        errorMessage.append(UNHANDLED_ERROR_MESSAGE);
        return new MutabilityAnalysisException(errorMessage.toString(), cause);
    }

    private void appendClassesAnalysed(StringBuilder errorMessage, Iterable<AnalysisResult> resultsSoFar) {
        for (AnalysisResult result : resultsSoFar) {
            errorMessage.append(String.format("    %s%n", result.className.asString()));
        }
    }
}

