/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.internal.org.objectweb.asm.FieldVisitor;
import org.mutabilitydetector.locations.CodeLocation;

public final class NonFinalFieldChecker
extends AsmMutabilityChecker {
    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (AccessModifierQuery.field(access).isNotFinal() && AccessModifierQuery.field(access).isNotStatic()) {
            this.setResult("Field is not final, if shared across threads the Java Memory Model will not guarantee it is initialised before it is read.", CodeLocation.FieldLocation.fieldLocation(name, CodeLocation.ClassLocation.fromInternalName(this.ownerClass)), MutabilityReason.NON_FINAL_FIELD);
        }
        return super.visitField(access, name, desc, signature, value);
    }
}

