/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.mutabilitydetector.AnalysisError;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.AnalysisSession;
import org.mutabilitydetector.Configuration;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.asmoverride.ClassLoadingVerifierFactory;
import org.mutabilitydetector.checkers.AllChecksRunner;
import org.mutabilitydetector.checkers.CheckerRunnerFactory;
import org.mutabilitydetector.checkers.ClassPathBasedCheckerRunnerFactory;
import org.mutabilitydetector.checkers.MutabilityCheckerFactory;
import org.mutabilitydetector.checkers.info.AnalysisDatabase;
import org.mutabilitydetector.checkers.info.AnalysisInProgress;
import org.mutabilitydetector.checkers.info.CyclicReferences;
import org.mutabilitydetector.checkers.info.InformationRetrievalRunner;
import org.mutabilitydetector.checkers.info.MutableTypeInformation;
import org.mutabilitydetector.classloading.CachingAnalysisClassLoader;
import org.mutabilitydetector.classloading.ClassForNameWrapper;
import org.mutabilitydetector.config.HardcodedResultsUsage;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.com.google.classpath.ClassPathFactory;
import org.mutabilitydetector.internal.com.google.common.cache.Cache;
import org.mutabilitydetector.internal.com.google.common.cache.CacheBuilder;
import org.mutabilitydetector.internal.com.google.common.collect.FluentIterable;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableList;
import org.mutabilitydetector.locations.Dotted;

public final class DefaultCachingAnalysisSession
implements AnalysisSession {
    private final MutabilityCheckerFactory checkerFactory;
    private final CheckerRunnerFactory checkerRunnerFactory;
    private final AnalysisDatabase database;
    private final AsmVerifierFactory verifierFactory;
    private final Configuration configuration;
    private final CyclicReferences cyclicReferences;
    private final Cache<Dotted, AnalysisResult> analysedClasses;

    private DefaultCachingAnalysisSession(CheckerRunnerFactory checkerRunnerFactory, MutabilityCheckerFactory checkerFactory, AsmVerifierFactory verifierFactory, Configuration configuration) {
        this.checkerRunnerFactory = checkerRunnerFactory;
        this.checkerFactory = checkerFactory;
        this.verifierFactory = verifierFactory;
        this.configuration = configuration;
        this.cyclicReferences = new CyclicReferences();
        this.analysedClasses = CacheBuilder.newBuilder().recordStats().build();
        this.analysedClasses.putAll(this.hardcodedResultsForDirectAssertion(configuration));
        InformationRetrievalRunner informationRetrievalRunner = new InformationRetrievalRunner(this, checkerRunnerFactory.createRunner());
        this.database = AnalysisDatabase.newAnalysisDatabase(informationRetrievalRunner);
    }

    private Map<Dotted, AnalysisResult> hardcodedResultsForDirectAssertion(Configuration configuration) {
        return configuration.howToUseHardcodedResults() == HardcodedResultsUsage.DIRECTLY_IN_ASSERTION ? configuration.hardcodedResults() : Collections.emptyMap();
    }

    public static AnalysisSession createWithGivenClassPath(ClassPath classpath, CheckerRunnerFactory checkerRunnerFactory, MutabilityCheckerFactory checkerFactory, AsmVerifierFactory verifierFactory, Configuration configuration) {
        return DefaultCachingAnalysisSession.createWithGivenClassPath(classpath, configuration, verifierFactory);
    }

    public static AnalysisSession createWithCurrentClassPath(Configuration configuration) {
        ClassPath classpath = new ClassPathFactory().createFromJVM();
        ClassLoadingVerifierFactory verifierFactory = new ClassLoadingVerifierFactory(new CachingAnalysisClassLoader(new ClassForNameWrapper()));
        return DefaultCachingAnalysisSession.createWithGivenClassPath(classpath, configuration, verifierFactory);
    }

    private static AnalysisSession createWithGivenClassPath(ClassPath classpath, Configuration configuration, AsmVerifierFactory verifierFactory) {
        return new DefaultCachingAnalysisSession(new ClassPathBasedCheckerRunnerFactory(classpath, configuration.exceptionPolicy()), new MutabilityCheckerFactory(configuration.reassignedFieldAlgorithm(), configuration.immutableContainerClasses()), verifierFactory, configuration);
    }

    @Override
    public AnalysisResult resultFor(Dotted className) {
        return this.requestAnalysis(className, AnalysisInProgress.noAnalysisUnderway());
    }

    @Override
    public AnalysisResult processTransitiveAnalysis(Dotted className, AnalysisInProgress analysisInProgress) {
        return this.requestAnalysis(className, analysisInProgress);
    }

    private AnalysisResult requestAnalysis(Dotted className, AnalysisInProgress analysisInProgress) {
        AnalysisResult existingResult = this.analysedClasses.getIfPresent(className);
        if (existingResult != null) {
            return existingResult;
        }
        MutableTypeInformation mutableTypeInformation = new MutableTypeInformation(this, this.configuration, this.cyclicReferences);
        AllChecksRunner allChecksRunner = new AllChecksRunner(this.checkerFactory, this.checkerRunnerFactory, this.verifierFactory, className);
        AnalysisResult result = allChecksRunner.runCheckers(ImmutableList.copyOf(this.getResults()), this.database, mutableTypeInformation, analysisInProgress);
        return this.addAnalysisResult(result);
    }

    private AnalysisResult addAnalysisResult(AnalysisResult result) {
        this.analysedClasses.put(result.className, result);
        return result;
    }

    public Collection<AnalysisResult> getResults() {
        return Collections.unmodifiableCollection(this.analysedClasses.asMap().values());
    }

    @Override
    public Map<Dotted, AnalysisResult> resultsByClass() {
        return Collections.unmodifiableMap(this.analysedClasses.asMap());
    }

    public Collection<AnalysisError> getErrors() {
        return FluentIterable.from(this.analysedClasses.asMap().values()).transformAndConcat(AnalysisResult.TO_ERRORS).toList();
    }
}

