/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.Configuration;
import org.mutabilitydetector.checkers.CheckerRunner;
import org.mutabilitydetector.checkers.MethodIs;
import org.mutabilitydetector.checkers.MutabilityAnalysisException;
import org.mutabilitydetector.checkers.MutabilityCheckerFactory;
import org.mutabilitydetector.checkers.info.CopyMethod;
import org.mutabilitydetector.config.HardcodedResultsUsage;
import org.mutabilitydetector.internal.com.google.common.base.Equivalence;
import org.mutabilitydetector.internal.com.google.common.base.Function;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableMap;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSetMultimap;
import org.mutabilitydetector.internal.com.google.common.collect.Iterables;
import org.mutabilitydetector.internal.com.google.common.collect.Maps;
import org.mutabilitydetector.internal.com.google.common.collect.Multimap;
import org.mutabilitydetector.internal.com.google.common.collect.Sets;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.locations.ClassNameConverter;
import org.mutabilitydetector.locations.Dotted;

@NotThreadSafe
public abstract class ConfigurationBuilder {
    private static final Equivalence<AnalysisResult> CLASSNAME_EQUIVALENCE = Equivalence.equals().onResultOf(AnalysisResult.TO_CLASSNAME);
    private static final Function<AnalysisResult, Equivalence.Wrapper<AnalysisResult>> TO_CLASSNAME_EQUIVALENCE_WRAPPER = new Function<AnalysisResult, Equivalence.Wrapper<AnalysisResult>>(){

        @Override
        public Equivalence.Wrapper<AnalysisResult> apply(AnalysisResult input) {
            return CLASSNAME_EQUIVALENCE.wrap(input);
        }
    };
    private static final Function<Equivalence.Wrapper<AnalysisResult>, AnalysisResult> UNWRAP = new Function<Equivalence.Wrapper<AnalysisResult>, AnalysisResult>(){

        @Override
        public AnalysisResult apply(Equivalence.Wrapper<AnalysisResult> input) {
            return input.get();
        }
    };
    private ImmutableSet.Builder<AnalysisResult> hardcodedResults = ImmutableSet.builder();
    private ImmutableSet.Builder<Dotted> hardcodedImmutableContainerClasses = ImmutableSet.builder();
    private CheckerRunner.ExceptionPolicy exceptionPolicy = CheckerRunner.ExceptionPolicy.FAIL_FAST;
    private MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm = MutabilityCheckerFactory.ReassignedFieldAnalysisChoice.NAIVE_PUT_FIELD_ANALYSIS;
    private ImmutableSetMultimap.Builder<String, CopyMethod> validCopyMethods = ImmutableSetMultimap.builder();
    private HardcodedResultsUsage howToUseHardcodedResults = HardcodedResultsUsage.LOOKUP_WHEN_REFERENCED;

    public abstract void configure();

    public final Configuration build() {
        this.configure();
        return new DefaultConfiguration((ImmutableSet)this.hardcodedResults.build(), (ImmutableSet)this.hardcodedImmutableContainerClasses.build(), this.exceptionPolicy, this.reassignedFieldAlgorithm, (ImmutableSetMultimap)this.validCopyMethods.build(), this.howToUseHardcodedResults);
    }

    protected final void setExceptionPolicy(CheckerRunner.ExceptionPolicy exceptionPolicy) {
        this.exceptionPolicy = exceptionPolicy;
    }

    protected final void hardcodeResult(AnalysisResult result) {
        this.hardcodedResults.add((Object)result);
    }

    protected final void hardcodeResults(Iterable<AnalysisResult> result) {
        this.hardcodedResults.addAll((Iterable)result);
    }

    protected final void hardcodeResults(AnalysisResult ... result) {
        this.hardcodeResults(Arrays.asList(result));
    }

    protected final void hardcodeAsDefinitelyImmutable(Class<?> immutableClass) {
        this.hardcodeResult(AnalysisResult.definitelyImmutable(Dotted.fromClass(immutableClass)));
    }

    protected final void hardcodeAsDefinitelyImmutable(String immutableClassName) {
        this.hardcodeResult(AnalysisResult.definitelyImmutable(Dotted.dotted(immutableClassName)));
    }

    protected final void setHowToUseHardcodedResults(HardcodedResultsUsage usage) {
        this.howToUseHardcodedResults = usage;
    }

    protected final Set<AnalysisResult> getCurrentlyHardcodedResults() {
        return this.hardcodedResults.build();
    }

    protected final void hardcodeAsImmutableContainerType(Class<?> immutableContainerClass) {
        this.hardcodeAsImmutableContainerType(Dotted.fromClass(immutableContainerClass));
    }

    protected final void hardcodeAsImmutableContainerType(String immutableContainerClassName) {
        this.hardcodeAsImmutableContainerType(Dotted.dotted(ClassNameConverter.CONVERTER.dotted(immutableContainerClassName)));
    }

    private void hardcodeAsImmutableContainerType(Dotted immutableContainerClassName) {
        this.hardcodedImmutableContainerClasses.add((Object)immutableContainerClassName);
    }

    protected void mergeHardcodedResultsFrom(Configuration otherConfiguration) {
        Sets.SetView<Equivalence.Wrapper<AnalysisResult>> union = Sets.union(Sets.newHashSet(Iterables.transform(this.hardcodedResults.build(), TO_CLASSNAME_EQUIVALENCE_WRAPPER)), ImmutableSet.copyOf(Iterables.transform(otherConfiguration.hardcodedResults().values(), TO_CLASSNAME_EQUIVALENCE_WRAPPER)));
        ImmutableSet<AnalysisResult> result = ImmutableSet.copyOf(Iterables.transform(union, UNWRAP));
        this.hardcodedResults = ImmutableSet.builder().addAll(result);
    }

    protected void mergeImmutableContainerTypesFrom(Configuration otherConfiguration) {
        Sets.SetView<Dotted> union = Sets.union(this.hardcodedImmutableContainerClasses.build(), otherConfiguration.immutableContainerClasses());
        this.hardcodedImmutableContainerClasses = ImmutableSet.builder().addAll(union);
    }

    protected void mergeValidCopyMethodsFrom(Configuration otherConfiguration) {
        this.validCopyMethods.putAll(otherConfiguration.hardcodedCopyMethods());
    }

    protected void merge(Configuration otherConfiguration) {
        this.mergeHardcodedResultsFrom(otherConfiguration);
        this.mergeImmutableContainerTypesFrom(otherConfiguration);
        this.mergeValidCopyMethodsFrom(otherConfiguration);
    }

    protected void useAdvancedReassignedFieldAlgorithm() {
        this.reassignedFieldAlgorithm = MutabilityCheckerFactory.ReassignedFieldAnalysisChoice.LAZY_INITIALISATION_ANALYSIS;
    }

    protected final void hardcodeValidCopyMethod(Class<?> fieldType, String fullyQualifiedMethodName, Class<?> argType) {
        if (argType == null || fieldType == null || fullyQualifiedMethodName == null) {
            throw new IllegalArgumentException("All parameters must be supplied - no nulls");
        }
        String className = fullyQualifiedMethodName.substring(0, fullyQualifiedMethodName.lastIndexOf("."));
        String methodName = fullyQualifiedMethodName.substring(fullyQualifiedMethodName.lastIndexOf(".") + 1);
        String desc = null;
        try {
            if (MethodIs.aConstructor(methodName)) {
                Constructor<?> ctor = Class.forName(className).getDeclaredConstructor(argType);
                desc = Type.getConstructorDescriptor(ctor);
            } else {
                Method method = Class.forName(className).getMethod(methodName, argType);
                desc = Type.getMethodDescriptor(method);
            }
        }
        catch (NoSuchMethodException e) {
            this.rethrow("No such method", e);
        }
        catch (SecurityException e) {
            this.rethrow("Security error", e);
        }
        catch (ClassNotFoundException e) {
            this.rethrow("Class not  found", e);
        }
        CopyMethod copyMethod = new CopyMethod(Dotted.dotted(className), methodName, desc);
        this.hardcodeValidCopyMethod(fieldType, copyMethod);
    }

    protected void hardcodeValidCopyMethod(Class<?> fieldType, CopyMethod copyMethod) {
        this.validCopyMethods.put((Object)fieldType.getCanonicalName(), (Object)copyMethod);
    }

    public Multimap<String, CopyMethod> getCopyMethodsAllowed() {
        return this.validCopyMethods.build();
    }

    private void rethrow(String message, Throwable e) {
        throw new MutabilityAnalysisException("Error in configuration: " + message + ": " + e.getMessage(), e);
    }

    @Immutable
    private static final class DefaultConfiguration
    implements Configuration {
        private final ImmutableSet<AnalysisResult> hardcodedResults;
        private final HardcodedResultsUsage howToUseHardcodedResults;
        private final ImmutableMap<Dotted, AnalysisResult> resultsByClassname;
        private final ImmutableSet<Dotted> immutableContainerClasses;
        private final ImmutableSetMultimap<String, CopyMethod> validCopyMethods;
        private final CheckerRunner.ExceptionPolicy exceptionPolicy;
        private final MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm;

        private DefaultConfiguration(ImmutableSet<AnalysisResult> predefinedResults, ImmutableSet<Dotted> immutableContainerClasses, CheckerRunner.ExceptionPolicy exceptionPolicy, MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm, ImmutableSetMultimap<String, CopyMethod> validCopyMethods, HardcodedResultsUsage howToUseHardcodedResults) {
            this.immutableContainerClasses = immutableContainerClasses;
            this.exceptionPolicy = exceptionPolicy;
            this.hardcodedResults = predefinedResults;
            this.howToUseHardcodedResults = howToUseHardcodedResults;
            this.resultsByClassname = Maps.uniqueIndex(this.hardcodedResults, AnalysisResult.TO_DOTTED_CLASSNAME);
            this.reassignedFieldAlgorithm = reassignedFieldAlgorithm;
            this.validCopyMethods = validCopyMethods;
        }

        @Override
        public Map<Dotted, AnalysisResult> hardcodedResults() {
            return this.resultsByClassname;
        }

        @Override
        public HardcodedResultsUsage howToUseHardcodedResults() {
            return this.howToUseHardcodedResults;
        }

        @Override
        public Set<Dotted> immutableContainerClasses() {
            return this.immutableContainerClasses;
        }

        @Override
        public CheckerRunner.ExceptionPolicy exceptionPolicy() {
            return this.exceptionPolicy;
        }

        @Override
        public MutabilityCheckerFactory.ReassignedFieldAnalysisChoice reassignedFieldAlgorithm() {
            return this.reassignedFieldAlgorithm;
        }

        @Override
        public ImmutableSetMultimap<String, CopyMethod> hardcodedCopyMethods() {
            return this.validCopyMethods;
        }
    }
}

