/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.test.infrastructure.process.MuleProcessController;

public class Stopper {
    private MuleProcessController mule;
    private File muleHome;
    private Log log;

    public Stopper(MuleProcessController mule, File muleHome, Log log) {
        this.mule = mule;
        this.muleHome = muleHome;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        this.validate();
        try {
            this.log.debug((CharSequence)"Stopping Mule ESB ...");
            this.mule.stop(new String[0]);
            this.log.info((CharSequence)"Mule ESB stopped.");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception e) throws MojoExecutionException {
        int pid;
        try {
            pid = this.mule.getProcessId();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually (Unknown PID)", e);
        }
        throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually (PID: " + pid + ".", e);
    }

    private void validate() throws MojoFailureException {
        if (null == this.muleHome) {
            throw new MojoFailureException("MULE_HOME is not set");
        }
        if (!this.muleHome.exists()) {
            this.log.error((CharSequence)("Couldn't find MULE_HOME directory at: " + this.muleHome));
            throw new MojoFailureException("Configuration variable MULE_HOME was not set.");
        }
        this.log.info((CharSequence)("MULE_HOME is set to: " + this.muleHome));
        if (!this.mule.isRunning()) {
            this.log.error((CharSequence)"Mule ESB is not running.");
            throw new MojoFailureException("Mule ESB is not running.");
        }
    }
}

