/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.util.LinkedList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.muleesb.AbstractMuleMojo;
import org.mule.tools.muleesb.ArtifactDescription;
import org.mule.tools.muleesb.ClusterStopper;

@Mojo(name="clusterStop", requiresProject=false, defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class ClusterStopMojo
extends AbstractMuleMojo {
    @Parameter(readonly=true, required=true)
    private ArtifactDescription muleDistribution;
    @Parameter(defaultValue="2", readonly=true, required=true)
    private Integer clusterSize;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        LinkedList<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        File[] muleHomes = new File[this.clusterSize.intValue()];
        for (int i = 0; i < this.clusterSize; ++i) {
            muleHomes[i] = new File(this.mavenProject.getBasedir() + "/target/mule" + i, "mule-enterprise-standalone-" + this.muleDistribution.getVersion());
            controllers.add(new MuleProcessController(muleHomes[i].getAbsolutePath(), this.timeout));
            if (muleHomes[i].exists()) continue;
            throw new MojoFailureException(muleHomes[i].getAbsolutePath() + "directory does not exist.");
        }
        new ClusterStopper(controllers, muleHomes, this.getLog()).execute();
    }
}

