/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.tools.muleesb.ArtifactDescription;
import org.mule.tools.muleesb.Deployer;

public abstract class AbstractMuleMojo
extends AbstractMojo {
    @Component
    protected MavenProject mavenProject;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="mule.skip")
    protected String skip;
    @Parameter
    protected File domain;
    @Parameter(property="script", required=false)
    protected File script;
    @Parameter(property="mule.timeout", required=false)
    protected int timeout;
    @Parameter
    private List<ArtifactDescription> artifactItems = new ArrayList<ArtifactDescription>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isNotEmpty((String)this.skip) && "true".equals(this.skip)) {
            this.getLog().info((CharSequence)("Skipping execution: skip=" + this.skip));
        } else {
            this.getLog().debug((CharSequence)("Executing mojo, skip=" + this.skip));
            this.doExecute();
        }
    }

    protected abstract void doExecute() throws MojoFailureException, MojoExecutionException;

    protected File getDependency(ArtifactDescription artifactDescription) throws MojoExecutionException, MojoFailureException {
        try {
            Artifact artifact = this.artifactFactory.createArtifact(artifactDescription.getGroupId(), artifactDescription.getArtifactId(), artifactDescription.getVersion(), null, artifactDescription.getType());
            this.getLog().info((CharSequence)("Resolving " + artifact));
            this.artifactResolver.resolve(artifact, this.mavenProject.getRemoteArtifactRepositories(), this.localRepository);
            return artifact.getFile();
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't download artifact: " + e.getMessage());
        }
    }

    protected void addDomain(Deployer deployer) throws MojoFailureException {
        if (this.domain != null && this.domain.exists()) {
            this.getLog().debug((CharSequence)("Adding domain with configuration: " + this.domain));
            deployer.addDomain(this.domain);
        } else {
            this.getLog().debug((CharSequence)("Domain configuration not found: " + this.domain));
        }
    }

    protected String readFile(String file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected void executeGroovyScript() throws MojoExecutionException {
        GroovyShell shell = new GroovyShell();
        this.getLog().info((CharSequence)("executing script: " + this.script.getAbsolutePath()));
        shell.setProperty("basedir", (Object)this.mavenProject.getBasedir());
        this.getLog().info((CharSequence)this.mavenProject.getBasedir().getAbsolutePath());
        try {
            shell.evaluate(this.readFile(this.script.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("error executing script: " + this.script.getAbsolutePath() + "\n" + e.getMessage());
        }
    }

    protected void addDependencies(Deployer deployer) throws MojoFailureException, MojoExecutionException {
        ArrayList<File> libraries = new ArrayList<File>();
        for (ArtifactDescription artifact : this.artifactItems) {
            libraries.add(this.getDependency(artifact));
        }
        deployer.addLibraries(libraries);
    }
}

