/*
 * Copyright 2012 castLabs, Berlin
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.mp4parser.boxes.samplegrouping;

import org.mp4parser.tools.Hex;

import java.nio.Buffer;
import java.nio.ByteBuffer;

/**
 *
 */
public class UnknownEntry extends GroupEntry {
    private ByteBuffer content;
    private String type;

    public UnknownEntry(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return type;
    }

    public ByteBuffer getContent() {
        return content;
    }

    public void setContent(ByteBuffer content) {
        this.content = (ByteBuffer) ((Buffer)content.duplicate()).rewind();
    }

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.content = (ByteBuffer) ((Buffer)byteBuffer.duplicate()).rewind();
    }

    @Override
    public ByteBuffer get() {
        return content.duplicate();
    }

    @Override
    public String toString() {
        ByteBuffer bb = content.duplicate();
        ((Buffer)bb).rewind();
        byte[] b = new byte[bb.limit()];
        bb.get(b);
        return "UnknownEntry{" +
                "content=" + Hex.encodeHex(b) +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UnknownEntry that = (UnknownEntry) o;

        if (content != null ? !content.equals(that.content) : that.content != null) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return content != null ? content.hashCode() : 0;
    }
}
