/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.ListDatabasesIterableImpl;
import com.mongodb.client.internal.MongoClientDelegate;
import com.mongodb.client.internal.MongoDatabaseImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.SocketStreamFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.session.ClientSession;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;

final class MongoClientImpl
implements MongoClient {
    private final MongoClientSettings settings;
    private final MongoClientDelegate delegate;

    MongoClientImpl(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(MongoClientImpl.createCluster(settings, mongoDriverInformation), settings, null);
    }

    private MongoClientImpl(Cluster cluster, MongoClientSettings settings, @Nullable OperationExecutor operationExecutor) {
        this.settings = Assertions.notNull("settings", settings);
        this.delegate = new MongoClientDelegate(Assertions.notNull("cluster", cluster), Collections.singletonList(settings.getCredential()), this, operationExecutor);
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return new MongoDatabaseImpl(databaseName, this.settings.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getWriteConcern(), this.settings.getRetryWrites(), this.settings.getReadConcern(), this.delegate.getOperationExecutor());
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, (Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    @Override
    public ClientSession startSession(ClientSessionOptions options) {
        ClientSession clientSession = this.delegate.createClientSession(Assertions.notNull("options", options));
        if (clientSession == null) {
            throw new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected");
        }
        return clientSession;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    Cluster getCluster() {
        return this.delegate.getCluster();
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        Assertions.notNull("settings", settings);
        List<MongoCredential> credentialList = settings.getCredential() != null ? Collections.singletonList(settings.getCredential()) : Collections.emptyList();
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), MongoClientImpl.getStreamFactory(settings), MongoClientImpl.getStreamFactory(settings), credentialList, EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList());
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings) {
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        if (streamFactoryFactory == null) {
            return new SocketStreamFactory(settings.getSocketSettings(), settings.getSslSettings());
        }
        return streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.settings.getCodecRegistry(), ReadPreference.primary(), this.delegate.getOperationExecutor());
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result) {
                return result.getString("name").getValue();
            }
        });
    }
}

