/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCallback;
import com.mongodb.DBCallbackFactory;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoInternalException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDBCallback
extends BasicBSONCallback
implements DBCallback {
    public static DBCallbackFactory FACTORY = new DefaultFactory();
    private LinkedList<String> _nameStack;
    final DBCollection _collection;
    final DB _db;
    static final Logger LOGGER = Logger.getLogger("com.mongo.DECODING");

    public DefaultDBCallback(DBCollection coll) {
        this._collection = coll;
        this._db = this._collection == null ? null : this._collection.getDB();
    }

    @Override
    public void gotDBRef(String name, String ns, ObjectId id) {
        if (id.equals(Bytes.COLLECTION_REF_ID)) {
            this.cur().put(name, this._collection);
        } else {
            this.cur().put(name, new DBRef(this._db, ns, id));
        }
    }

    @Override
    public void objectStart(boolean array, String name) {
        this._nameStack.addLast(name);
        super.objectStart(array, name);
    }

    @Override
    public Object objectDone() {
        BSONObject o = (BSONObject)super.objectDone();
        String lastName = null;
        if (this._nameStack.size() > 0) {
            lastName = this._nameStack.removeLast();
        }
        if (!(o instanceof List) && lastName != null && o.containsField("$ref") && o.containsField("$id")) {
            return this.cur().put(lastName, new DBRef(this._db, o));
        }
        return o;
    }

    @Override
    public BSONObject create() {
        return this._create(null);
    }

    @Override
    public BSONObject create(boolean array, List<String> path) {
        if (array) {
            return new BasicDBList();
        }
        return this._create(path);
    }

    private DBObject _create(List<String> path) {
        Class c = null;
        if (this._collection != null && this._collection._objectClass != null) {
            if (path == null || path.size() == 0) {
                c = this._collection._objectClass;
            } else {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < path.size(); ++i) {
                    if (i > 0) {
                        buf.append(".");
                    }
                    buf.append(path.get(i));
                }
                c = this._collection.getInternalClass(buf.toString());
            }
        }
        if (c != null) {
            try {
                return (DBObject)c.newInstance();
            }
            catch (InstantiationException ie) {
                LOGGER.log(Level.FINE, "can't create a: " + c, ie);
                throw new MongoInternalException("can't instantiate a : " + c, ie);
            }
            catch (IllegalAccessException iae) {
                LOGGER.log(Level.FINE, "can't create a: " + c, iae);
                throw new MongoInternalException("can't instantiate a : " + c, iae);
            }
        }
        return new BasicDBObject();
    }

    DBObject dbget() {
        return (DBObject)this.get();
    }

    @Override
    public void reset() {
        this._nameStack = new LinkedList();
        super.reset();
    }

    static class DefaultFactory
    implements DBCallbackFactory {
        DefaultFactory() {
        }

        public DBCallback create(DBCollection collection) {
            return new DefaultDBCallback(collection);
        }
    }
}

