/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.serialization.curl.OutboundRequestToCurlSerializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.filters.Filter;
import org.mockserver.filters.Filters;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.filters.RequestResponseLogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.proxy.error.Logging;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.SSLFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Proxy server;
    private final RequestLogFilter requestLogFilter;
    private final RequestResponseLogFilter requestResponseLogFilter;
    private final boolean onwardSslStatusUnknown;
    private final Filters filters = new Filters();
    private LogFormatter logFormatter = new LogFormatter(this.logger);
    private NettyHttpClient httpClient = new NettyHttpClient();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private OutboundRequestToCurlSerializer outboundRequestToCurlSerializer = new OutboundRequestToCurlSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public HttpProxyHandler(Proxy server, RequestLogFilter requestLogFilter, RequestResponseLogFilter requestResponseLogFilter, Boolean onwardSslStatusUnknown) {
        super(false);
        this.server = server;
        this.requestLogFilter = requestLogFilter;
        this.requestResponseLogFilter = requestResponseLogFilter;
        this.onwardSslStatusUnknown = onwardSslStatusUnknown != null ? onwardSslStatusUnknown : false;
        this.filters.withFilter(new HttpRequest(), (Filter)new HopByHopHeaderFilter());
        this.filters.withFilter(new HttpRequest(), (Filter)requestLogFilter);
        this.filters.withFilter(new HttpRequest(), (Filter)requestResponseLogFilter);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        try {
            this.logFormatter.traceLog("received request:{}" + System.getProperty("line.separator"), new Object[]{request});
            if (request.getMethod().getValue().equals("CONNECT")) {
                PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                SSLFactory.addSubjectAlternativeName((String)request.getPath().getValue());
                ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler()});
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead((Object)request);
            } else if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && request.getMethod().getValue().equals("OPTIONS") && !request.getFirstHeader("Origin").isEmpty()) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/status")) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/clear")) {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                this.requestLogFilter.clear(httpRequest);
                this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/reset")) {
                this.requestLogFilter.reset();
                this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/dumpToLog")) {
                this.requestResponseLogFilter.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()), request.hasQueryStringParameter("type", "java"));
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/retrieve")) {
                HttpRequest[] requests = this.requestLogFilter.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.OK, this.httpRequestSerializer.serialize(requests), "application/json");
            } else if (request.matches("PUT", "/verify")) {
                Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                this.logFormatter.infoLog("verifying:{}", new Object[]{verification});
                String result = this.requestLogFilter.verify(verification);
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                }
            } else if (request.matches("PUT", "/verifySequence")) {
                VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                String result = this.requestLogFilter.verify(verificationSequence);
                this.logFormatter.infoLog("verifying sequence:{}", new Object[]{verificationSequence});
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                }
            } else if (request.matches("PUT", "/stop")) {
                ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.ACCEPTED.code())));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HttpProxyHandler.this.server.stop();
                    }
                }).start();
            } else {
                OutboundHttpRequest outboundHttpRequest = OutboundHttpRequest.outboundRequest((InetSocketAddress)((InetSocketAddress)ctx.channel().attr(HttpProxy.REMOTE_SOCKET).get()), (String)"", (HttpRequest)this.filters.applyOnRequestFilters(request));
                if (outboundHttpRequest != null) {
                    HttpResponse response = this.sendRequest(outboundHttpRequest);
                    this.logFormatter.infoLog("returning response:{}" + System.getProperty("line.separator") + " for request as json:{}" + System.getProperty("line.separator") + " as curl:{}", new Object[]{response, request, this.outboundRequestToCurlSerializer.toCurl(outboundHttpRequest)});
                    this.writeResponse(ctx, request, response);
                } else {
                    this.writeResponse(ctx, request, HttpResponse.notFoundResponse());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + request, (Throwable)e);
            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private HttpResponse sendRequest(OutboundHttpRequest outboundHttpRequest) {
        HttpResponse httpResponse = this.filters.applyOnResponseFilters((HttpRequest)outboundHttpRequest, this.httpClient.sendRequest(outboundHttpRequest, this.onwardSslStatusUnknown));
        if (httpResponse == null) {
            httpResponse = HttpResponse.notFoundResponse();
        }
        return httpResponse;
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        if (ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders(response);
        }
        this.writeResponse(ctx, request, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders(response);
        }
        if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            ctx.write((Object)response);
        } else {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void addCORSHeaders(HttpResponse response) {
        String methods = "CONNECT, DELETE, GET, HEAD, OPTIONS, POST, PUT, TRACE";
        String headers = "Allow, Content-Encoding, Content-Length, Content-Type, ETag, Expires, Last-Modified, Location, Server, Vary";
        if (response.getFirstHeader("Access-Control-Allow-Origin").isEmpty()) {
            response.withHeader("Access-Control-Allow-Origin", new String[]{"*"});
        }
        if (response.getFirstHeader("Access-Control-Allow-Methods").isEmpty()) {
            response.withHeader("Access-Control-Allow-Methods", new String[]{methods});
        }
        if (response.getFirstHeader("Access-Control-Allow-Headers").isEmpty()) {
            response.withHeader("Access-Control-Allow-Headers", new String[]{headers});
        }
        if (response.getFirstHeader("Access-Control-Expose-Headers").isEmpty()) {
            response.withHeader("Access-Control-Expose-Headers", new String[]{headers});
        }
        if (response.getFirstHeader("Access-Control-Max-Age").isEmpty()) {
            response.withHeader("Access-Control-Max-Age", new String[]{"1"});
        }
        if (response.getFirstHeader("X-CORS").isEmpty()) {
            response.withHeader("X-CORS", new String[]{"MockServer CORS support enabled by default, to disable ConfigurationProperties.enableCORSForAPI(false) or -Dmockserver.disableCORS=false"});
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!Logging.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by HTTP proxy handler -> closing pipeline " + ctx.channel(), cause);
        }
        ctx.close();
    }
}

