/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver.callback;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.UUID;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    public static final String WEB_SOCKET_URI = "/_mockserver_callback_websocket";
    private WebSocketServerHandshaker handshaker;
    private WebSocketClientRegistry webSocketClientRegistry;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public WebSocketServerHandler(WebSocketClientRegistry webSocketClientRegistry) {
        this.webSocketClientRegistry = webSocketClientRegistry;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(WEB_SOCKET_URI)) {
            this.upgradeChannel(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        boolean websocketHandshake = msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(WEB_SOCKET_URI);
        boolean websocketFrame = msg instanceof WebSocketFrame;
        return websocketHandshake || websocketFrame;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(final ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        this.handshaker = new WebSocketServerHandshakerFactory("ws://" + httpRequest.headers().get("Host") + WEB_SOCKET_URI, null, true).newHandshaker((HttpRequest)httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            final String clientId = UUID.randomUUID().toString();
            this.handshaker.handshake(ctx.channel(), httpRequest, new DefaultHttpHeaders().add("X-CLIENT-REGISTRATION-ID", (Object)clientId), ctx.channel().newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    WebSocketServerHandler.this.webSocketClientRegistry.registerClient(clientId, ctx);
                }
            });
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
        } else if (frame instanceof TextWebSocketFrame) {
            this.webSocketClientRegistry.receivedTextWebSocketFrame(ctx, (TextWebSocketFrame)frame);
        } else {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("web socket server caught exception", cause);
        ctx.close();
    }
}

