/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.StringBody;
import org.mockserver.url.URLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(MockServerRequestDecoder.class);
    private final boolean isSecure;

    public MockServerRequestDecoder(boolean isSecure) {
        this.isSecure = isSecure;
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest, List<Object> out) {
        HttpRequest httpRequest = new HttpRequest();
        if (fullHttpRequest != null) {
            this.setMethod(httpRequest, fullHttpRequest);
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(fullHttpRequest.uri());
            this.setPath(httpRequest, queryStringDecoder);
            this.setQueryString(httpRequest, queryStringDecoder);
            this.setBody(httpRequest, fullHttpRequest);
            this.setHeaders(httpRequest, fullHttpRequest);
            this.setCookies(httpRequest, fullHttpRequest);
            httpRequest.withKeepAlive(Boolean.valueOf(HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)));
            httpRequest.withSecure(Boolean.valueOf(this.isSecure));
        }
        out.add(httpRequest);
    }

    private void setMethod(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        httpRequest.withMethod(fullHttpResponse.method().name());
    }

    private void setPath(HttpRequest httpRequest, QueryStringDecoder queryStringDecoder) {
        httpRequest.withPath(URLParser.returnPath((String)queryStringDecoder.path()));
    }

    private void setQueryString(HttpRequest httpRequest, QueryStringDecoder queryStringDecoder) {
        try {
            httpRequest.withQueryStringParameters(queryStringDecoder.parameters());
        }
        catch (IllegalArgumentException iae) {
            logger.debug("Exception while parsing query string", (Throwable)iae);
        }
    }

    private void setBody(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        if (fullHttpRequest.content() != null && fullHttpRequest.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpRequest.content().readableBytes()];
            fullHttpRequest.content().readBytes(bodyBytes);
            if (bodyBytes.length > 0) {
                if (ContentTypeMapper.isBinary((String)fullHttpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE))) {
                    httpRequest.withBody((Body)new BinaryBody(bodyBytes));
                } else {
                    Charset requestCharset = ContentTypeMapper.determineCharsetForMessage((HttpMessage)fullHttpRequest);
                    httpRequest.withBody((Body)new StringBody(new String(bodyBytes, requestCharset), ContentTypeMapper.DEFAULT_HTTP_CHARACTER_SET.equals(requestCharset) ? null : requestCharset));
                }
            }
        }
    }

    private void setHeaders(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        HttpHeaders headers = fullHttpResponse.headers();
        for (String headerName : headers.names()) {
            httpRequest.withHeader(new Header(headerName, (Collection)headers.getAll(headerName)));
        }
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        for (String cookieHeader : fullHttpResponse.headers().getAll((CharSequence)HttpHeaderNames.COOKIE)) {
            Set decodedCookies = ServerCookieDecoder.LAX.decode(cookieHeader);
            for (Cookie decodedCookie : decodedCookies) {
                httpRequest.withCookie(new org.mockserver.model.Cookie(decodedCookie.name(), decodedCookie.value()));
            }
        }
    }
}

