/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.mproc.impl;

import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.smsc.library.OriginationType;
import org.mobicents.smsc.mproc.MProcMessage;
import org.mobicents.smsc.mproc.MProcNewMessage;
import org.mobicents.smsc.mproc.MProcRuleException;
import org.mobicents.smsc.mproc.OrigType;
import org.mobicents.smsc.mproc.PostDeliveryProcessor;
import org.mobicents.smsc.mproc.impl.MProcUtility;

public class PostDeliveryProcessorImpl
implements PostDeliveryProcessor {
    private Logger logger;
    private int defaultValidityPeriodHours;
    private int maxValidityPeriodHours;
    private boolean deliveryFailure;
    private boolean actionAdded = false;
    private int rerouteMessage = -1;
    private FastList<MProcNewMessage> postedMessages = new FastList();

    public PostDeliveryProcessorImpl(int defaultValidityPeriodHours, int maxValidityPeriodHours, Logger logger, boolean deliveryFailure) {
        this.defaultValidityPeriodHours = defaultValidityPeriodHours;
        this.maxValidityPeriodHours = maxValidityPeriodHours;
        this.logger = logger;
        this.deliveryFailure = deliveryFailure;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public FastList<MProcNewMessage> getPostedMessages() {
        return this.postedMessages;
    }

    public boolean isNeedRerouteMessages() {
        return this.rerouteMessage != -1;
    }

    public int getNewNetworkId() {
        return this.rerouteMessage;
    }

    public MProcNewMessage createNewEmptyMessage(OrigType origType) {
        return MProcUtility.createNewEmptyMessage(this.defaultValidityPeriodHours, this.maxValidityPeriodHours, OriginationType.toOriginationType(origType));
    }

    public MProcNewMessage createNewCopyMessage(MProcMessage message) {
        return MProcUtility.createNewCopyMessage(message, false, this.defaultValidityPeriodHours, this.maxValidityPeriodHours);
    }

    public MProcNewMessage createNewResponseMessage(MProcMessage message) {
        return MProcUtility.createNewCopyMessage(message, true, this.defaultValidityPeriodHours, this.maxValidityPeriodHours);
    }

    public void postNewMessage(MProcNewMessage message) throws MProcRuleException {
        this.postedMessages.add((Object)message);
    }

    public void rerouteMessage(int newNetworkId) throws MProcRuleException {
        if (this.actionAdded) {
            throw new MProcRuleException("Another action already added");
        }
        this.actionAdded = true;
        this.rerouteMessage = newNetworkId;
    }

    public boolean isDeliveryFailure() {
        return this.deliveryFailure;
    }
}

