/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.mproc.impl;

import java.util.Date;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.smsc.library.OriginationType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.mproc.MProcMessage;
import org.mobicents.smsc.mproc.MProcNewMessage;
import org.mobicents.smsc.mproc.MProcRuleException;
import org.mobicents.smsc.mproc.OrigType;
import org.mobicents.smsc.mproc.PostArrivalProcessor;
import org.mobicents.smsc.mproc.impl.MProcMessageImpl;
import org.mobicents.smsc.mproc.impl.MProcUtility;

public class PostArrivalProcessorImpl
implements PostArrivalProcessor {
    private Logger logger;
    private int defaultValidityPeriodHours;
    private int maxValidityPeriodHours;
    private boolean actionAdded = false;
    private boolean needDropMessage = false;
    private boolean needRejectMessage = false;
    private FastList<MProcNewMessage> postedMessages = new FastList();

    public PostArrivalProcessorImpl(int defaultValidityPeriodHours, int maxValidityPeriodHours, Logger logger) {
        this.defaultValidityPeriodHours = defaultValidityPeriodHours;
        this.maxValidityPeriodHours = maxValidityPeriodHours;
        this.logger = logger;
    }

    public boolean isNeedDropMessage() {
        return this.needDropMessage;
    }

    public boolean isNeedRejectMessage() {
        return this.needRejectMessage;
    }

    public FastList<MProcNewMessage> getPostedMessages() {
        return this.postedMessages;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void dropMessage() throws MProcRuleException {
        if (this.actionAdded) {
            throw new MProcRuleException("Another action already added");
        }
        this.actionAdded = true;
        this.needDropMessage = true;
    }

    public void rejectMessage() throws MProcRuleException {
        if (this.actionAdded) {
            throw new MProcRuleException("Another action already added");
        }
        this.actionAdded = true;
        this.needRejectMessage = true;
    }

    public void updateMessageNetworkId(MProcMessage message, int newNetworkId) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.getSmsSet().setNetworkId(newNetworkId);
        sms.getSmsSet().setCorrelationId(null);
    }

    public void updateMessageDestAddrTon(MProcMessage message, int newDestTon) throws MProcRuleException {
        MProcUtility.checkDestAddrTon(newDestTon);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.getSmsSet().setDestAddrTon(newDestTon);
        sms.getSmsSet().setCorrelationId(null);
    }

    public void updateMessageDestAddrNpi(MProcMessage message, int newDestNpi) throws MProcRuleException {
        MProcUtility.checkDestAddrNpi(newDestNpi);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.getSmsSet().setDestAddrNpi(newDestNpi);
        sms.getSmsSet().setCorrelationId(null);
    }

    public void updateMessageDestAddr(MProcMessage message, String newDigits) throws MProcRuleException {
        MProcUtility.checkDestAddr(newDigits);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.getSmsSet().setDestAddr(newDigits);
        sms.getSmsSet().setCorrelationId(null);
    }

    public void updateMessageSourceAddrTon(MProcMessage message, int newDestTon) throws MProcRuleException {
        MProcUtility.checkSourceAddrTon(newDestTon);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setSourceAddrTon(newDestTon);
    }

    public void updateMessageSourceAddrNpi(MProcMessage message, int newDestNpi) throws MProcRuleException {
        MProcUtility.checkSourceAddrNpi(newDestNpi);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setSourceAddrNpi(newDestNpi);
    }

    public void updateMessageSourceAddr(MProcMessage message, String newDigits) throws MProcRuleException {
        MProcUtility.checkSourceAddr(newDigits);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setSourceAddr(newDigits);
    }

    public void updateShortMessageText(MProcMessage message, String newShortMessageText) throws MProcRuleException {
        MProcUtility.checkShortMessageText(newShortMessageText);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setShortMessageText(newShortMessageText);
    }

    public void updateShortMessageBin(MProcMessage message, byte[] newShortMessageBin) throws MProcRuleException {
        MProcUtility.checkShortMessageBin(newShortMessageBin);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setShortMessageBin(newShortMessageBin);
    }

    public void updateScheduleDeliveryTime(MProcMessage message, Date scheduleDeliveryTime) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        scheduleDeliveryTime = MProcUtility.checkScheduleDeliveryTime(sms, scheduleDeliveryTime);
        sms.setScheduleDeliveryTime(scheduleDeliveryTime);
    }

    public void updateValidityPeriod(MProcMessage message, Date newValidityPeriod) {
        newValidityPeriod = MProcUtility.checkValidityPeriod(newValidityPeriod, this.defaultValidityPeriodHours, this.maxValidityPeriodHours);
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setValidityPeriod(newValidityPeriod);
    }

    public void updateDataCoding(MProcMessage message, int newDataCoding) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setDataCoding(newDataCoding);
    }

    public void updateDataCodingGsm7(MProcMessage message) {
        this.updateDataCoding(message, 0);
    }

    public void updateDataCodingGsm8(MProcMessage message) {
        this.updateDataCoding(message, 4);
    }

    public void updateDataCodingUcs2(MProcMessage message) {
        this.updateDataCoding(message, 8);
    }

    public void updateNationalLanguageSingleShift(MProcMessage message, int newNationalLanguageSingleShift) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setNationalLanguageSingleShift(newNationalLanguageSingleShift);
    }

    public void updateNationalLanguageLockingShift(MProcMessage message, int newNationalLanguageLockingShift) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setNationalLanguageLockingShift(newNationalLanguageLockingShift);
    }

    public void updateEsmClass(MProcMessage message, int newEsmClass) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(newEsmClass);
    }

    public void updateEsmClass_ModeDatagram(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(MProcUtility.setEsmClass_ModeDatagram(sms.getEsmClass()));
    }

    public void updateEsmClass_ModeTransaction(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(MProcUtility.setEsmClass_ModeTransaction(sms.getEsmClass()));
    }

    public void updateEsmClass_ModeStoreAndForward(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(MProcUtility.setEsmClass_ModeStoreAndForward(sms.getEsmClass()));
    }

    public void updateEsmClass_TypeNormalMessage(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(MProcUtility.setEsmClass_TypeNormalMessage(sms.getEsmClass()));
    }

    public void updateEsmClass_TypeDeliveryReceipt(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(MProcUtility.setEsmClass_TypeDeliveryReceipt(sms.getEsmClass()));
    }

    public void updateEsmClass_UDHIndicatorPresent(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(MProcUtility.setEsmClass_UDHIndicatorPresent(sms.getEsmClass()));
    }

    public void updateEsmClass_UDHIndicatorAbsent(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setEsmClass(MProcUtility.setEsmClass_UDHIndicatorAbsent(sms.getEsmClass()));
    }

    public void updatePriority(MProcMessage message, int newPriority) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setPriority(newPriority);
    }

    public void updateRegisteredDelivery(MProcMessage message, int newRegisteredDelivery) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setRegisteredDelivery(newRegisteredDelivery);
    }

    public void updateRegisteredDelivery_DeliveryReceiptNo(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptNo(sms.getRegisteredDelivery()));
    }

    public void updateRegisteredDelivery_DeliveryReceiptOnSuccessOrFailure(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptOnSuccessOrFailure(sms.getRegisteredDelivery()));
    }

    public void updateRegisteredDelivery_DeliveryReceiptOnFailure(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptOnFailure(sms.getRegisteredDelivery()));
    }

    public void updateRegisteredDelivery_DeliveryReceiptOnSuccess(MProcMessage message) {
        MProcMessageImpl msg = (MProcMessageImpl)message;
        Sms sms = msg.getSmsContent();
        sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptOnSuccess(sms.getRegisteredDelivery()));
    }

    public MProcNewMessage createNewEmptyMessage(OrigType origType) {
        return MProcUtility.createNewEmptyMessage(this.defaultValidityPeriodHours, this.maxValidityPeriodHours, OriginationType.toOriginationType(origType));
    }

    public MProcNewMessage createNewCopyMessage(MProcMessage message) {
        return MProcUtility.createNewCopyMessage(message, false, this.defaultValidityPeriodHours, this.maxValidityPeriodHours);
    }

    public MProcNewMessage createNewResponseMessage(MProcMessage message) {
        return MProcUtility.createNewCopyMessage(message, true, this.defaultValidityPeriodHours, this.maxValidityPeriodHours);
    }

    public void postNewMessage(MProcNewMessage message) throws MProcRuleException {
        this.postedMessages.add((Object)message);
    }
}

