/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.mproc.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.smsc.mproc.MProcMessage;
import org.mobicents.smsc.mproc.MProcNewMessage;
import org.mobicents.smsc.mproc.MProcRuleBaseImpl;
import org.mobicents.smsc.mproc.MProcRuleDefault;
import org.mobicents.smsc.mproc.OrigType;
import org.mobicents.smsc.mproc.PostArrivalProcessor;
import org.mobicents.smsc.mproc.PostDeliveryProcessor;
import org.mobicents.smsc.mproc.PostDeliveryTempFailureProcessor;
import org.mobicents.smsc.mproc.PostHrSriProcessor;
import org.mobicents.smsc.mproc.PostImsiProcessor;
import org.mobicents.smsc.mproc.PostPreDeliveryProcessor;
import org.mobicents.smsc.mproc.ProcessingType;

public class MProcRuleDefaultImpl
extends MProcRuleBaseImpl
implements MProcRuleDefault {
    private static final Logger logger = Logger.getLogger(MProcRuleDefaultImpl.class);
    private static final String DEST_TON_MASK = "destTonMask";
    private static final String DEST_NPI_MASK = "destNpiMask";
    private static final String DEST_DIG_MASK = "destDigMask";
    private static final String ORIGINATING_MASK = "originatingMask";
    private static final String NETWORK_ID_MASK = "networkIdMask";
    private static final String ORIGIN_NETWORK_ID_MASK = "originNetworkIdMask";
    private static final String ORIG_ESME_NAME_MASK = "origEsmeNameMask";
    private static final String ORIGINATOR_SCCP_ADDRESS_MASK = "originatorSccpAddressMask";
    private static final String IMSI_DIGITS_MASK = "imsiDigitsMask";
    private static final String NNN_DIGITS_MASK = "nnnDigitsMask";
    private static final String PROCESSING_TYPE = "processingType";
    private static final String ERROR_CODE = "errorCode";
    private static final String NEW_NETWORK_ID = "newNetworkId";
    private static final String NEW_DEST_TON = "newDestTon";
    private static final String NEW_DEST_NPI = "newDestNpi";
    private static final String ADD_DEST_DIG_PREFIX = "addDestDigPrefix";
    private static final String MAKE_COPY = "makeCopy";
    private static final String DROP_AFTER_SRI = "dropAfterSri";
    private static final String DROP_AFTER_TEMP_FAIL = "dropAfterTempFail";
    private static final String NEW_NETWORK_ID_AFTER_SRI = "newNetworkIdAfterSri";
    private static final String NEW_NETWORK_ID_AFTER_PERM_FAIL = "newNetworkIdAfterPermFail";
    private static final String NEW_NETWORK_ID_AFTER_TEMP_FAIL = "newNetworkIdAfterTempFail";
    private static final String HR_BY_PASS = "hrByPass";
    private int destTonMask = -1;
    private int destNpiMask = -1;
    private String destDigMask = "-1";
    private OrigType originatingMask = null;
    private int networkIdMask = -1;
    private int originNetworkIdMask = -1;
    private String origEsmeNameMask = "-1";
    private String originatorSccpAddressMask = "-1";
    private String imsiDigitsMask = "-1";
    private String nnnDigitsMask = "-1";
    private ProcessingType processingType = null;
    private String errorCode = "-1";
    private int newNetworkId = -1;
    private int newDestTon = -1;
    private int newDestNpi = -1;
    private String addDestDigPrefix = "-1";
    private boolean makeCopy = false;
    private boolean dropAfterSri = false;
    private boolean dropAfterTempFail = false;
    private int newNetworkIdAfterSri = -1;
    private int newNetworkIdAfterPermFail = -1;
    private int newNetworkIdAfterTempFail = -1;
    private boolean hrByPass = false;
    private Pattern destDigMaskPattern;
    private Pattern origEsmeNameMaskPattern;
    private Pattern originatorSccpAddressMaskPattern;
    private Pattern imsiDigitsMaskPattern;
    private Pattern nnnDigitsMaskPattern;
    private FastMap<Integer, Integer> errorCodePattern;
    protected static final XMLFormat<MProcRuleDefaultImpl> M_PROC_RULE_DEFAULT_XML = new XMLFormat<MProcRuleDefaultImpl>(MProcRuleDefaultImpl.class){

        public void read(XMLFormat.InputElement xml, MProcRuleDefaultImpl mProcRule) throws XMLStreamException {
            M_PROC_RULE_BASE_XML.read(xml, (Object)mProcRule);
            mProcRule.destTonMask = xml.getAttribute(MProcRuleDefaultImpl.DEST_TON_MASK, -1);
            mProcRule.destNpiMask = xml.getAttribute(MProcRuleDefaultImpl.DEST_NPI_MASK, -1);
            mProcRule.destDigMask = xml.getAttribute(MProcRuleDefaultImpl.DEST_DIG_MASK, "-1");
            String val = xml.getAttribute(MProcRuleDefaultImpl.ORIGINATING_MASK, "");
            if (val != null) {
                try {
                    mProcRule.originatingMask = Enum.valueOf(OrigType.class, val);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            mProcRule.networkIdMask = xml.getAttribute(MProcRuleDefaultImpl.NETWORK_ID_MASK, -1);
            mProcRule.originNetworkIdMask = xml.getAttribute(MProcRuleDefaultImpl.ORIGIN_NETWORK_ID_MASK, -1);
            mProcRule.origEsmeNameMask = xml.getAttribute(MProcRuleDefaultImpl.ORIG_ESME_NAME_MASK, "-1");
            mProcRule.originatorSccpAddressMask = xml.getAttribute(MProcRuleDefaultImpl.ORIGINATOR_SCCP_ADDRESS_MASK, "-1");
            mProcRule.imsiDigitsMask = xml.getAttribute(MProcRuleDefaultImpl.IMSI_DIGITS_MASK, "-1");
            mProcRule.nnnDigitsMask = xml.getAttribute(MProcRuleDefaultImpl.NNN_DIGITS_MASK, "-1");
            val = xml.getAttribute(MProcRuleDefaultImpl.PROCESSING_TYPE, "");
            if (val != null) {
                try {
                    mProcRule.processingType = Enum.valueOf(ProcessingType.class, val);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            mProcRule.errorCode = xml.getAttribute(MProcRuleDefaultImpl.ERROR_CODE, "-1");
            mProcRule.newNetworkId = xml.getAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID, -1);
            mProcRule.newDestTon = xml.getAttribute(MProcRuleDefaultImpl.NEW_DEST_TON, -1);
            mProcRule.newDestNpi = xml.getAttribute(MProcRuleDefaultImpl.NEW_DEST_NPI, -1);
            mProcRule.addDestDigPrefix = xml.getAttribute(MProcRuleDefaultImpl.ADD_DEST_DIG_PREFIX, "-1");
            mProcRule.makeCopy = xml.getAttribute(MProcRuleDefaultImpl.MAKE_COPY, false);
            mProcRule.hrByPass = xml.getAttribute(MProcRuleDefaultImpl.HR_BY_PASS, false);
            mProcRule.dropAfterSri = xml.getAttribute(MProcRuleDefaultImpl.DROP_AFTER_SRI, false);
            mProcRule.dropAfterTempFail = xml.getAttribute(MProcRuleDefaultImpl.DROP_AFTER_TEMP_FAIL, false);
            mProcRule.newNetworkIdAfterSri = xml.getAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID_AFTER_SRI, -1);
            mProcRule.newNetworkIdAfterPermFail = xml.getAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID_AFTER_PERM_FAIL, -1);
            mProcRule.newNetworkIdAfterTempFail = xml.getAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID_AFTER_TEMP_FAIL, -1);
            mProcRule.resetPattern();
        }

        public void write(MProcRuleDefaultImpl mProcRule, XMLFormat.OutputElement xml) throws XMLStreamException {
            M_PROC_RULE_BASE_XML.write((Object)mProcRule, xml);
            if (mProcRule.destTonMask != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.DEST_TON_MASK, mProcRule.destTonMask);
            }
            if (mProcRule.destNpiMask != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.DEST_NPI_MASK, mProcRule.destNpiMask);
            }
            if (mProcRule.destDigMask != null && !mProcRule.destDigMask.equals("") && !mProcRule.destDigMask.equals("-1")) {
                xml.setAttribute(MProcRuleDefaultImpl.DEST_DIG_MASK, mProcRule.destDigMask);
            }
            if (mProcRule.originatingMask != null) {
                xml.setAttribute(MProcRuleDefaultImpl.ORIGINATING_MASK, mProcRule.originatingMask.toString());
            }
            if (mProcRule.networkIdMask != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.NETWORK_ID_MASK, mProcRule.networkIdMask);
            }
            if (mProcRule.originNetworkIdMask != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.ORIGIN_NETWORK_ID_MASK, mProcRule.originNetworkIdMask);
            }
            if (mProcRule.origEsmeNameMask != null && !mProcRule.origEsmeNameMask.equals("") && !mProcRule.origEsmeNameMask.equals("-1")) {
                xml.setAttribute(MProcRuleDefaultImpl.ORIG_ESME_NAME_MASK, mProcRule.origEsmeNameMask);
            }
            if (mProcRule.originatorSccpAddressMask != null && !mProcRule.originatorSccpAddressMask.equals("") && !mProcRule.originatorSccpAddressMask.equals("-1")) {
                xml.setAttribute(MProcRuleDefaultImpl.ORIGINATOR_SCCP_ADDRESS_MASK, mProcRule.originatorSccpAddressMask);
            }
            if (mProcRule.imsiDigitsMask != null && !mProcRule.imsiDigitsMask.equals("") && !mProcRule.imsiDigitsMask.equals("-1")) {
                xml.setAttribute(MProcRuleDefaultImpl.IMSI_DIGITS_MASK, mProcRule.imsiDigitsMask);
            }
            if (mProcRule.nnnDigitsMask != null && !mProcRule.nnnDigitsMask.equals("") && !mProcRule.nnnDigitsMask.equals("-1")) {
                xml.setAttribute(MProcRuleDefaultImpl.NNN_DIGITS_MASK, mProcRule.nnnDigitsMask);
            }
            if (mProcRule.processingType != null) {
                xml.setAttribute(MProcRuleDefaultImpl.PROCESSING_TYPE, mProcRule.processingType.toString());
            }
            if (mProcRule.errorCode != null && !mProcRule.errorCode.equals("") && !mProcRule.errorCode.equals("-1")) {
                xml.setAttribute(MProcRuleDefaultImpl.ERROR_CODE, mProcRule.errorCode);
            }
            if (mProcRule.newNetworkId != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID, mProcRule.newNetworkId);
            }
            if (mProcRule.newDestTon != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.NEW_DEST_TON, mProcRule.newDestTon);
            }
            if (mProcRule.newDestNpi != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.NEW_DEST_NPI, mProcRule.newDestNpi);
            }
            if (mProcRule.addDestDigPrefix != null && !mProcRule.addDestDigPrefix.equals("") && !mProcRule.addDestDigPrefix.equals("-1")) {
                xml.setAttribute(MProcRuleDefaultImpl.ADD_DEST_DIG_PREFIX, mProcRule.addDestDigPrefix);
            }
            if (mProcRule.makeCopy) {
                xml.setAttribute(MProcRuleDefaultImpl.MAKE_COPY, mProcRule.makeCopy);
            }
            if (mProcRule.hrByPass) {
                xml.setAttribute(MProcRuleDefaultImpl.HR_BY_PASS, mProcRule.hrByPass);
            }
            if (mProcRule.dropAfterSri) {
                xml.setAttribute(MProcRuleDefaultImpl.DROP_AFTER_SRI, mProcRule.dropAfterSri);
            }
            if (mProcRule.dropAfterTempFail) {
                xml.setAttribute(MProcRuleDefaultImpl.DROP_AFTER_TEMP_FAIL, mProcRule.dropAfterTempFail);
            }
            if (mProcRule.newNetworkIdAfterSri != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID_AFTER_SRI, mProcRule.newNetworkIdAfterSri);
            }
            if (mProcRule.newNetworkIdAfterPermFail != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID_AFTER_PERM_FAIL, mProcRule.newNetworkIdAfterPermFail);
            }
            if (mProcRule.newNetworkIdAfterTempFail != -1) {
                xml.setAttribute(MProcRuleDefaultImpl.NEW_NETWORK_ID_AFTER_TEMP_FAIL, mProcRule.newNetworkIdAfterTempFail);
            }
        }
    };

    public String getRuleClassName() {
        return "mproc";
    }

    public int getDestTonMask() {
        return this.destTonMask;
    }

    public void setDestTonMask(int destTonMask) {
        this.destTonMask = destTonMask;
    }

    public int getDestNpiMask() {
        return this.destNpiMask;
    }

    public void setDestNpiMask(int destNpiMask) {
        this.destNpiMask = destNpiMask;
    }

    public String getDestDigMask() {
        return this.destDigMask;
    }

    public void setDestDigMask(String destDigMask) {
        this.destDigMask = destDigMask;
        this.resetPattern();
    }

    public OrigType getOriginatingMask() {
        return this.originatingMask;
    }

    public void setOriginatingMask(OrigType originatingMask) {
        this.originatingMask = originatingMask;
    }

    public String getOrigEsmeNameMask() {
        return this.origEsmeNameMask;
    }

    public void setOrigEsmeNameMask(String origEsmeNameMask) {
        this.origEsmeNameMask = origEsmeNameMask;
        this.resetPattern();
    }

    public int getNetworkIdMask() {
        return this.networkIdMask;
    }

    public void setNetworkIdMask(int networkIdMask) {
        this.networkIdMask = networkIdMask;
    }

    public int getOriginNetworkIdMask() {
        return this.originNetworkIdMask;
    }

    public void setOriginNetworkIdMask(int originNetworkIdMask) {
        this.originNetworkIdMask = originNetworkIdMask;
    }

    public String getOriginatorSccpAddressMask() {
        return this.originatorSccpAddressMask;
    }

    public void setOriginatorSccpAddressMask(String originatorSccpAddressMask) {
        this.originatorSccpAddressMask = originatorSccpAddressMask;
        this.resetPattern();
    }

    public String getImsiDigitsMask() {
        return this.imsiDigitsMask;
    }

    public void setImsiDigitsMask(String imsiDigitsMask) {
        this.imsiDigitsMask = imsiDigitsMask;
        this.resetPattern();
    }

    public String getNnnDigitsMask() {
        return this.nnnDigitsMask;
    }

    public void setNnnDigitsMask(String nnnDigitsMask) {
        this.nnnDigitsMask = nnnDigitsMask;
        this.resetPattern();
    }

    public ProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(ProcessingType processingType) {
        this.processingType = processingType;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        this.resetPattern();
    }

    public int getNewNetworkId() {
        return this.newNetworkId;
    }

    public void setNewNetworkId(int newNetworkId) {
        this.newNetworkId = newNetworkId;
    }

    public int getNewDestTon() {
        return this.newDestTon;
    }

    public void setNewDestTon(int newDestTon) {
        this.newDestTon = newDestTon;
    }

    public int getNewDestNpi() {
        return this.newDestNpi;
    }

    public void setNewDestNpi(int newDestNpi) {
        this.newDestNpi = newDestNpi;
    }

    public String getAddDestDigPrefix() {
        return this.addDestDigPrefix;
    }

    public void setAddDestDigPrefix(String addDestDigPrefix) {
        this.addDestDigPrefix = addDestDigPrefix;
    }

    public boolean isMakeCopy() {
        return this.makeCopy;
    }

    public void setMakeCopy(boolean makeCopy) {
        this.makeCopy = makeCopy;
    }

    public boolean isHrByPass() {
        return this.hrByPass;
    }

    public void setHrByPass(boolean hrByPass) {
        this.hrByPass = hrByPass;
    }

    public boolean isDropAfterSri() {
        return this.dropAfterSri;
    }

    public void setDropAfterSri(boolean dropAfterSri) {
        this.dropAfterSri = dropAfterSri;
    }

    public int getNewNetworkIdAfterSri() {
        return this.newNetworkIdAfterSri;
    }

    public void setNewNetworkIdAfterSri(int newNetworkIdAfterSri) {
        this.newNetworkIdAfterSri = newNetworkIdAfterSri;
    }

    public int getNewNetworkIdAfterPermFail() {
        return this.newNetworkIdAfterPermFail;
    }

    public void setNewNetworkIdAfterPermFail(int newNetworkIdAfterPermFail) {
        this.newNetworkIdAfterPermFail = newNetworkIdAfterPermFail;
    }

    public boolean isDropAfterTempFail() {
        return this.dropAfterTempFail;
    }

    public void setDropAfterTempFail(boolean dropAfterTempFail) {
        this.dropAfterTempFail = dropAfterTempFail;
    }

    public int getNewNetworkIdAfterTempFail() {
        return this.newNetworkIdAfterTempFail;
    }

    public void setNewNetworkIdAfterTempFail(int newNetworkIdAfterTempFail) {
        this.newNetworkIdAfterTempFail = newNetworkIdAfterTempFail;
    }

    private void resetPattern() {
        this.destDigMaskPattern = this.destDigMask != null && !this.destDigMask.equals("") && !this.destDigMask.equals("-1") ? Pattern.compile(this.destDigMask) : null;
        this.origEsmeNameMaskPattern = this.origEsmeNameMask != null && !this.origEsmeNameMask.equals("") && !this.origEsmeNameMask.equals("-1") ? Pattern.compile(this.origEsmeNameMask) : null;
        this.originatorSccpAddressMaskPattern = this.originatorSccpAddressMask != null && !this.originatorSccpAddressMask.equals("") && !this.originatorSccpAddressMask.equals("-1") ? Pattern.compile(this.originatorSccpAddressMask) : null;
        this.imsiDigitsMaskPattern = this.imsiDigitsMask != null && !this.imsiDigitsMask.equals("") && !this.imsiDigitsMask.equals("-1") ? Pattern.compile(this.imsiDigitsMask) : null;
        this.nnnDigitsMaskPattern = this.nnnDigitsMask != null && !this.nnnDigitsMask.equals("") && !this.nnnDigitsMask.equals("-1") ? Pattern.compile(this.nnnDigitsMask) : null;
        if (this.errorCode != null && !this.errorCode.equals("") && !this.errorCode.equals("-1")) {
            String[] ss;
            FastMap ecp = new FastMap();
            for (String s : ss = this.errorCode.split(",")) {
                try {
                    Integer i1 = Integer.parseInt(s);
                    ecp.put((Object)i1, (Object)i1);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.errorCodePattern = ecp;
        } else {
            this.errorCodePattern = null;
        }
    }

    protected void setRuleParameters(int destTonMask, int destNpiMask, String destDigMask, OrigType originatingMask, int networkIdMask, int originNetworkIdMask, String origEsmeNameMask, String originatorSccpAddressMask, String imsiDigitsMask, String nnnDigitsMask, ProcessingType processingType, String errorCode, int newNetworkId, int newDestTon, int newDestNpi, String addDestDigPrefix, boolean makeCopy, boolean hrByPass, boolean dropAfterSri, boolean dropAfterTempFail, int newNetworkIdAfterSri, int newNetworkIdAfterPermFail, int newNetworkIdAfterTempFail) {
        this.destTonMask = destTonMask;
        this.destNpiMask = destNpiMask;
        this.destDigMask = destDigMask;
        this.originatingMask = originatingMask;
        this.networkIdMask = networkIdMask;
        this.originNetworkIdMask = originNetworkIdMask;
        this.origEsmeNameMask = origEsmeNameMask;
        this.originatorSccpAddressMask = originatorSccpAddressMask;
        this.imsiDigitsMask = imsiDigitsMask;
        this.nnnDigitsMask = nnnDigitsMask;
        this.processingType = processingType;
        this.errorCode = errorCode;
        this.newNetworkId = newNetworkId;
        this.newDestTon = newDestTon;
        this.newDestNpi = newDestNpi;
        this.addDestDigPrefix = addDestDigPrefix;
        this.makeCopy = makeCopy;
        this.hrByPass = hrByPass;
        this.dropAfterSri = dropAfterSri;
        this.dropAfterTempFail = dropAfterTempFail;
        this.newNetworkIdAfterSri = newNetworkIdAfterSri;
        this.newNetworkIdAfterPermFail = newNetworkIdAfterPermFail;
        this.newNetworkIdAfterTempFail = newNetworkIdAfterTempFail;
        this.resetPattern();
    }

    public boolean isForPostArrivalState() {
        return this.makeCopy || this.newNetworkId != -1 || this.addDestDigPrefix != null && !this.addDestDigPrefix.equals("") && !this.addDestDigPrefix.equals("-1") || this.newDestNpi != -1 || this.newDestTon != -1;
    }

    public boolean isForPostHrSriState() {
        return this.hrByPass;
    }

    public boolean isForPostPreDeliveryState() {
        return false;
    }

    public boolean isForPostImsiRequestState() {
        return this.dropAfterSri || this.newNetworkIdAfterSri != -1;
    }

    public boolean isForPostDeliveryState() {
        return this.newNetworkIdAfterPermFail != -1;
    }

    public boolean isForPostDeliveryTempFailureState() {
        return this.dropAfterTempFail || this.newNetworkIdAfterTempFail != -1;
    }

    private boolean matches(MProcMessage message) {
        Matcher m;
        if (this.destTonMask != -1 && this.destTonMask != message.getDestAddrTon()) {
            return false;
        }
        if (this.destNpiMask != -1 && this.destNpiMask != message.getDestAddrNpi()) {
            return false;
        }
        if (this.destDigMaskPattern != null) {
            if (message.getDestAddr() == null) {
                return false;
            }
            m = this.destDigMaskPattern.matcher(message.getDestAddr());
            if (!m.matches()) {
                return false;
            }
        }
        if (this.originatingMask != null && this.originatingMask != message.getOriginationType()) {
            return false;
        }
        if (this.networkIdMask != -1 && this.networkIdMask != message.getNetworkId()) {
            return false;
        }
        if (this.originNetworkIdMask != -1 && this.originNetworkIdMask != message.getOrigNetworkId()) {
            return false;
        }
        if (this.origEsmeNameMaskPattern != null) {
            if (message.getOrigEsmeName() == null) {
                return false;
            }
            m = this.origEsmeNameMaskPattern.matcher(message.getOrigEsmeName());
            if (!m.matches()) {
                return false;
            }
        }
        if (this.originatorSccpAddressMaskPattern != null) {
            if (message.getOriginatorSccpAddress() == null) {
                return false;
            }
            m = this.originatorSccpAddressMaskPattern.matcher(message.getOriginatorSccpAddress());
            if (!m.matches()) {
                return false;
            }
        }
        if (this.imsiDigitsMaskPattern != null) {
            if (message.getImsiDigits() == null) {
                return false;
            }
            m = this.imsiDigitsMaskPattern.matcher(message.getImsiDigits());
            if (!m.matches()) {
                return false;
            }
        }
        if (this.nnnDigitsMaskPattern != null) {
            if (message.getNnnDigits() == null) {
                return false;
            }
            m = this.nnnDigitsMaskPattern.matcher(message.getNnnDigits());
            if (!m.matches()) {
                return false;
            }
        }
        if (this.processingType != null && this.processingType != message.getProcessingType()) {
            return false;
        }
        if (this.errorCodePattern != null && !this.errorCodePattern.containsKey((Object)message.getErrorCode())) {
            return false;
        }
        return this.originatorSccpAddressMask == null || this.originatorSccpAddressMask.length() <= 0 || this.originatorSccpAddressMask.equals("-1") || message.getShortMessageText() == null || message.getShortMessageText().length() <= 0 || this.originatorSccpAddressMask.charAt(0) == message.getShortMessageText().charAt(0);
    }

    public boolean matchesPostHrSri(MProcMessage message) {
        return this.matches(message);
    }

    public boolean matchesPostArrival(MProcMessage message) {
        return this.matches(message);
    }

    public boolean matchesPostPreDelivery(MProcMessage message) {
        return this.matches(message);
    }

    public boolean matchesPostImsiRequest(MProcMessage message) {
        return this.matches(message);
    }

    public boolean matchesPostDelivery(MProcMessage message) {
        return this.matches(message);
    }

    public boolean matchesPostDeliveryTempFailure(MProcMessage message) {
        return this.matches(message);
    }

    public void onPostArrival(PostArrivalProcessor factory, MProcMessage message) throws Exception {
        if (this.makeCopy) {
            MProcNewMessage copy = factory.createNewCopyMessage(message);
            factory.postNewMessage(copy);
        }
        if (this.newNetworkId != -1) {
            factory.updateMessageNetworkId(message, this.newNetworkId);
        }
        if (this.addDestDigPrefix != null && !this.addDestDigPrefix.equals("") && !this.addDestDigPrefix.equals("-1")) {
            String destAddr = this.getAddDestDigPrefix() + message.getDestAddr();
            factory.updateMessageDestAddr(message, destAddr);
        }
        if (this.newDestNpi != -1) {
            factory.updateMessageDestAddrNpi(message, this.newDestNpi);
        }
        if (this.newDestTon != -1) {
            factory.updateMessageDestAddrTon(message, this.newDestTon);
        }
    }

    public void onPostHrSri(PostHrSriProcessor factory, MProcMessage message) throws Exception {
        if (this.hrByPass) {
            factory.byPassHr();
        }
    }

    public void onPostPreDelivery(PostPreDeliveryProcessor factory, MProcMessage message) throws Exception {
    }

    public void onPostImsiRequest(PostImsiProcessor factory, MProcMessage messages) throws Exception {
        if (this.dropAfterSri) {
            factory.dropMessage();
        } else if (this.newNetworkIdAfterSri != -1) {
            factory.rerouteMessage(this.newNetworkIdAfterSri);
        }
    }

    public void onPostDelivery(PostDeliveryProcessor factory, MProcMessage message) throws Exception {
        if (this.newNetworkIdAfterPermFail != -1 && factory.isDeliveryFailure()) {
            factory.rerouteMessage(this.newNetworkIdAfterPermFail);
        }
    }

    public void onPostDeliveryTempFailure(PostDeliveryTempFailureProcessor factory, MProcMessage message) throws Exception {
        if (this.dropAfterTempFail) {
            factory.dropMessage();
        } else if (this.newNetworkIdAfterTempFail != -1) {
            factory.rerouteMessage(this.newNetworkIdAfterTempFail);
        }
    }

    public void setInitialRuleParameters(String parametersString) throws Exception {
        String[] args = this.splitParametersString(parametersString);
        int count = 0;
        boolean success = false;
        int destTonMask = -1;
        int destNpiMask = -1;
        String destDigMask = "-1";
        String originatingMask = "-1";
        int networkIdMask = -1;
        int originNetworkIdMask = -1;
        String origEsmeNameMask = "-1";
        String originatorSccpAddressMask = "-1";
        String imsiDigitsMask = "-1";
        String nnnDigitsMask = "-1";
        String processingType = "-1";
        String errorCode = "-1";
        int newNetworkId = -1;
        int newDestTon = -1;
        int newDestNpi = -1;
        String addDestDigPrefix = "-1";
        boolean makeCopy = false;
        boolean hrByPass = false;
        boolean dropAfterSri = false;
        boolean dropAfterTempFail = false;
        int newNetworkIdAfterSri = -1;
        int newNetworkIdAfterPermFail = -1;
        int newNetworkIdAfterTempFail = -1;
        while (count < args.length) {
            String command = args[count++];
            if (count >= args.length) continue;
            String value = args[count++];
            if (command.equals("desttonmask")) {
                destTonMask = Integer.parseInt(value);
                continue;
            }
            if (command.equals("destnpimask")) {
                destNpiMask = Integer.parseInt(value);
                continue;
            }
            if (command.equals("destdigmask")) {
                destDigMask = value;
                continue;
            }
            if (command.equals("originatingmask")) {
                originatingMask = value;
                continue;
            }
            if (command.equals("networkidmask")) {
                networkIdMask = Integer.parseInt(value);
                continue;
            }
            if (command.equals("originnetworkidmask")) {
                originNetworkIdMask = Integer.parseInt(value);
                continue;
            }
            if (command.equals("origesmenamemask")) {
                origEsmeNameMask = value;
                continue;
            }
            if (command.equals("originatorsccpaddressmask")) {
                originatorSccpAddressMask = value;
                continue;
            }
            if (command.equals("imsidigitsmask")) {
                imsiDigitsMask = value;
                continue;
            }
            if (command.equals("nnndigitsmask")) {
                nnnDigitsMask = value;
                continue;
            }
            if (command.equals("processingtype")) {
                processingType = value;
                continue;
            }
            if (command.equals("errorcode")) {
                errorCode = value;
                continue;
            }
            if (command.equals("newnetworkid")) {
                newNetworkId = Integer.parseInt(value);
                success = true;
                continue;
            }
            if (command.equals("newdestton")) {
                newDestTon = Integer.parseInt(value);
                success = true;
                continue;
            }
            if (command.equals("newdestnpi")) {
                newDestNpi = Integer.parseInt(value);
                success = true;
                continue;
            }
            if (command.equals("adddestdigprefix")) {
                addDestDigPrefix = value;
                success = true;
                continue;
            }
            if (command.equals("makecopy")) {
                makeCopy = Boolean.parseBoolean(value);
                success = true;
                continue;
            }
            if (command.equals("hrbypass")) {
                hrByPass = Boolean.parseBoolean(value);
                success = true;
                continue;
            }
            if (command.equals("dropaftersri")) {
                dropAfterSri = Boolean.parseBoolean(value);
                success = true;
                continue;
            }
            if (command.equals("dropaftertempfail")) {
                dropAfterTempFail = Boolean.parseBoolean(value);
                success = true;
                continue;
            }
            if (command.equals("newnetworkidaftersri")) {
                newNetworkIdAfterSri = Integer.parseInt(value);
                success = true;
                continue;
            }
            if (command.equals("newnetworkidafterpermfail")) {
                newNetworkIdAfterPermFail = Integer.parseInt(value);
                success = true;
                continue;
            }
            if (!command.equals("newnetworkidaftertempfail")) continue;
            newNetworkIdAfterTempFail = Integer.parseInt(value);
            success = true;
        }
        if (!success) {
            throw new Exception("Setting of MProcRule parameters failed: no parameter is provided");
        }
        OrigType originatingMaskVal = null;
        try {
            originatingMaskVal = OrigType.valueOf((String)originatingMask);
        }
        catch (Exception e) {
            // empty catch block
        }
        ProcessingType processingTypeVal = null;
        try {
            processingTypeVal = ProcessingType.valueOf((String)processingType);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setRuleParameters(destTonMask, destNpiMask, destDigMask, originatingMaskVal, networkIdMask, originNetworkIdMask, origEsmeNameMask, originatorSccpAddressMask, imsiDigitsMask, nnnDigitsMask, processingTypeVal, errorCode, newNetworkId, newDestTon, newDestNpi, addDestDigPrefix, makeCopy, hrByPass, dropAfterSri, dropAfterTempFail, newNetworkIdAfterSri, newNetworkIdAfterPermFail, newNetworkIdAfterTempFail);
    }

    public void updateRuleParameters(String parametersString) throws Exception {
        String[] args = this.splitParametersString(parametersString);
        int count = 0;
        boolean success = false;
        while (count < args.length) {
            String command = args[count++];
            if (count >= args.length) continue;
            String value = args[count++];
            if (command.equals("desttonmask")) {
                int val = Integer.parseInt(value);
                this.setDestTonMask(val);
                success = true;
                continue;
            }
            if (command.equals("destnpimask")) {
                int val = Integer.parseInt(value);
                this.setDestNpiMask(val);
                success = true;
                continue;
            }
            if (command.equals("destdigmask")) {
                this.setDestDigMask(value);
                success = true;
                continue;
            }
            if (command.equals("originatingmask")) {
                if (value != null && value.equals("-1")) {
                    this.setOriginatingMask(null);
                } else {
                    OrigType originatingMask = Enum.valueOf(OrigType.class, value);
                    this.setOriginatingMask(originatingMask);
                }
                success = true;
                continue;
            }
            if (command.equals("networkidmask")) {
                int val = Integer.parseInt(value);
                this.setNetworkIdMask(val);
                success = true;
                continue;
            }
            if (command.equals("originnetworkidmask")) {
                int val = Integer.parseInt(value);
                this.setOriginNetworkIdMask(val);
                success = true;
                continue;
            }
            if (command.equals("origesmenamemask")) {
                this.setOrigEsmeNameMask(value);
                success = true;
                continue;
            }
            if (command.equals("originatorsccpaddressmask")) {
                this.setOriginatorSccpAddressMask(value);
                success = true;
                continue;
            }
            if (command.equals("imsidigitsmask")) {
                this.setImsiDigitsMask(value);
                success = true;
                continue;
            }
            if (command.equals("nnndigitsmask")) {
                this.setNnnDigitsMask(value);
                success = true;
                continue;
            }
            if (command.equals("processingtype")) {
                if (value != null && value.equals("-1")) {
                    this.setProcessingType(null);
                } else {
                    ProcessingType processingType = Enum.valueOf(ProcessingType.class, value);
                    this.setProcessingType(processingType);
                }
                success = true;
                continue;
            }
            if (command.equals("errorcode")) {
                this.setErrorCode(value);
                success = true;
                continue;
            }
            if (command.equals("newnetworkid")) {
                int val = Integer.parseInt(value);
                this.setNewNetworkId(val);
                success = true;
                continue;
            }
            if (command.equals("newdestton")) {
                int val = Integer.parseInt(value);
                this.setNewDestTon(val);
                success = true;
                continue;
            }
            if (command.equals("newdestnpi")) {
                int val = Integer.parseInt(value);
                this.setNewDestNpi(val);
                success = true;
                continue;
            }
            if (command.equals("adddestdigprefix")) {
                this.setAddDestDigPrefix(value);
                success = true;
                continue;
            }
            if (command.equals("makecopy")) {
                boolean val = Boolean.parseBoolean(value);
                this.setMakeCopy(val);
                success = true;
                continue;
            }
            if (command.equals("hrbypass")) {
                boolean val = Boolean.parseBoolean(value);
                this.setHrByPass(val);
                success = true;
                continue;
            }
            if (command.equals("dropaftersri")) {
                boolean val = Boolean.parseBoolean(value);
                this.setDropAfterSri(val);
                success = true;
                continue;
            }
            if (command.equals("dropaftertempfail")) {
                boolean val = Boolean.parseBoolean(value);
                this.setDropAfterTempFail(val);
                success = true;
                continue;
            }
            if (command.equals("newnetworkidaftersri")) {
                int val = Integer.parseInt(value);
                this.setNewNetworkIdAfterSri(val);
                success = true;
                continue;
            }
            if (command.equals("newnetworkidafterpermfail")) {
                int val = Integer.parseInt(value);
                this.setNewNetworkIdAfterPermFail(val);
                success = true;
                continue;
            }
            if (!command.equals("newnetworkidaftertempfail")) continue;
            int val = Integer.parseInt(value);
            this.setNewNetworkIdAfterTempFail(val);
            success = true;
        }
        if (!success) {
            throw new Exception("Setting of MProcRule parameters failed: no parameter is provided");
        }
    }

    public String getRuleParameters() {
        StringBuilder sb = new StringBuilder();
        int parNumber = 0;
        if (this.destTonMask != -1) {
            this.writeParameter(sb, parNumber++, DEST_TON_MASK, this.destTonMask, ", ", "=");
        }
        if (this.destNpiMask != -1) {
            this.writeParameter(sb, parNumber++, DEST_NPI_MASK, this.destNpiMask, ", ", "=");
        }
        if (this.destDigMask != null && !this.destDigMask.equals("") && !this.destDigMask.equals("-1")) {
            this.writeParameter(sb, parNumber++, DEST_DIG_MASK, this.destDigMask, ", ", "=");
        }
        if (this.originatingMask != null) {
            this.writeParameter(sb, parNumber++, ORIGINATING_MASK, this.originatingMask, ", ", "=");
        }
        if (this.networkIdMask != -1) {
            this.writeParameter(sb, parNumber++, NETWORK_ID_MASK, this.networkIdMask, ", ", "=");
        }
        if (this.originNetworkIdMask != -1) {
            this.writeParameter(sb, parNumber++, ORIGIN_NETWORK_ID_MASK, this.originNetworkIdMask, ", ", "=");
        }
        if (this.origEsmeNameMask != null && !this.origEsmeNameMask.equals("") && !this.origEsmeNameMask.equals("-1")) {
            this.writeParameter(sb, parNumber++, ORIG_ESME_NAME_MASK, this.origEsmeNameMask, ", ", "=");
        }
        if (this.originatorSccpAddressMask != null && !this.originatorSccpAddressMask.equals(" ") && !this.originatorSccpAddressMask.equals("-1")) {
            this.writeParameter(sb, parNumber++, ORIGINATOR_SCCP_ADDRESS_MASK, this.originatorSccpAddressMask, ", ", "=");
        }
        if (this.imsiDigitsMask != null && !this.imsiDigitsMask.equals("") && !this.imsiDigitsMask.equals("-1")) {
            this.writeParameter(sb, parNumber++, IMSI_DIGITS_MASK, this.imsiDigitsMask, ", ", "=");
        }
        if (this.nnnDigitsMask != null && !this.nnnDigitsMask.equals("") && !this.nnnDigitsMask.equals("-1")) {
            this.writeParameter(sb, parNumber++, NNN_DIGITS_MASK, this.nnnDigitsMask, ", ", "=");
        }
        if (this.processingType != null) {
            this.writeParameter(sb, parNumber++, PROCESSING_TYPE, this.processingType, ", ", "=");
        }
        if (this.errorCode != null && !this.errorCode.equals("") && !this.errorCode.equals("-1")) {
            this.writeParameter(sb, parNumber++, ERROR_CODE, this.errorCode, ", ", "=");
        }
        if (this.newNetworkId != -1) {
            this.writeParameter(sb, parNumber++, NEW_NETWORK_ID, this.newNetworkId, ", ", "=");
        }
        if (this.newDestTon != -1) {
            this.writeParameter(sb, parNumber++, NEW_DEST_TON, this.newDestTon, ", ", "=");
        }
        if (this.newDestNpi != -1) {
            this.writeParameter(sb, parNumber++, NEW_DEST_NPI, this.newDestNpi, ", ", "=");
        }
        if (this.addDestDigPrefix != null && !this.addDestDigPrefix.equals("") && !this.addDestDigPrefix.equals("-1")) {
            this.writeParameter(sb, parNumber++, ADD_DEST_DIG_PREFIX, this.addDestDigPrefix, ", ", "=");
        }
        if (this.makeCopy) {
            this.writeParameter(sb, parNumber++, MAKE_COPY, this.makeCopy, ", ", "=");
        }
        if (this.hrByPass) {
            this.writeParameter(sb, parNumber++, HR_BY_PASS, this.hrByPass, ", ", "=");
        }
        if (this.dropAfterSri) {
            this.writeParameter(sb, parNumber++, DROP_AFTER_SRI, this.dropAfterSri, ", ", "=");
        }
        if (this.dropAfterTempFail) {
            this.writeParameter(sb, parNumber++, DROP_AFTER_TEMP_FAIL, this.dropAfterTempFail, ", ", "=");
        }
        if (this.newNetworkIdAfterSri != -1) {
            this.writeParameter(sb, parNumber++, NEW_NETWORK_ID_AFTER_SRI, this.newNetworkIdAfterSri, ", ", "=");
        }
        if (this.newNetworkIdAfterPermFail != -1) {
            this.writeParameter(sb, parNumber++, NEW_NETWORK_ID_AFTER_PERM_FAIL, this.newNetworkIdAfterPermFail, ", ", "=");
        }
        if (this.newNetworkIdAfterTempFail != -1) {
            this.writeParameter(sb, parNumber++, NEW_NETWORK_ID_AFTER_TEMP_FAIL, this.newNetworkIdAfterTempFail, ", ", "=");
        }
        return sb.toString();
    }
}

