/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.mproc.impl;

import java.util.Date;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.mproc.MProcNewMessage;
import org.mobicents.smsc.mproc.MProcRuleException;
import org.mobicents.smsc.mproc.impl.MProcUtility;

public class MProcNewMessageImpl
implements MProcNewMessage {
    private int defaultValidityPeriodHours;
    private int maxValidityPeriodHours;
    private Sms sms;

    public MProcNewMessageImpl(Sms sms, int defaultValidityPeriodHours, int maxValidityPeriodHours) {
        this.defaultValidityPeriodHours = defaultValidityPeriodHours;
        this.maxValidityPeriodHours = maxValidityPeriodHours;
        this.sms = sms;
    }

    public Sms getSmsContent() {
        return this.sms;
    }

    public int getNetworkId() {
        return this.sms.getSmsSet().getNetworkId();
    }

    public void setNetworkId(int val) {
        this.sms.getSmsSet().setNetworkId(val);
    }

    public int getDestAddrTon() {
        return this.sms.getSmsSet().getDestAddrTon();
    }

    public void setDestAddrTon(int val) throws MProcRuleException {
        MProcUtility.checkDestAddrTon(val);
        this.sms.getSmsSet().setDestAddrTon(val);
    }

    public int getDestAddrNpi() {
        return this.sms.getSmsSet().getDestAddrNpi();
    }

    public void setDestAddrNpi(int val) throws MProcRuleException {
        MProcUtility.checkDestAddrNpi(val);
        this.sms.getSmsSet().setDestAddrNpi(val);
    }

    public String getDestAddr() {
        return this.sms.getSmsSet().getDestAddr();
    }

    public void setDestAddr(String val) throws MProcRuleException {
        MProcUtility.checkDestAddr(val);
        this.sms.getSmsSet().setDestAddr(val);
    }

    public int getSourceAddrTon() {
        return this.sms.getSourceAddrTon();
    }

    public void setSourceAddrTon(int val) throws MProcRuleException {
        MProcUtility.checkSourceAddrTon(val);
        this.sms.setSourceAddrTon(val);
    }

    public int getSourceAddrNpi() {
        return this.sms.getSourceAddrNpi();
    }

    public void setSourceAddrNpi(int val) throws MProcRuleException {
        MProcUtility.checkSourceAddrNpi(val);
        this.sms.setSourceAddrNpi(val);
    }

    public String getSourceAddr() {
        return this.sms.getSourceAddr();
    }

    public void setSourceAddr(String val) throws MProcRuleException {
        MProcUtility.checkSourceAddr(val);
        this.sms.setSourceAddr(val);
    }

    public String getShortMessageText() {
        return this.sms.getShortMessageText();
    }

    public void setShortMessageText(String val) throws MProcRuleException {
        MProcUtility.checkShortMessageText(val);
        this.sms.setShortMessageText(val);
    }

    public byte[] getShortMessageBin() {
        return this.sms.getShortMessageBin();
    }

    public void setShortMessageBin(byte[] val) throws MProcRuleException {
        MProcUtility.checkShortMessageBin(val);
        this.sms.setShortMessageBin(val);
    }

    public Date getScheduleDeliveryTime() {
        return this.sms.getScheduleDeliveryTime();
    }

    public void setScheduleDeliveryTime(Date scheduleDeliveryTime) {
        scheduleDeliveryTime = MProcUtility.checkScheduleDeliveryTime(this.sms, scheduleDeliveryTime);
        this.sms.setScheduleDeliveryTime(scheduleDeliveryTime);
    }

    public Date getValidityPeriod() {
        return this.sms.getValidityPeriod();
    }

    public void setValidityPeriod(Date validityPeriod) {
        validityPeriod = MProcUtility.checkValidityPeriod(validityPeriod, this.defaultValidityPeriodHours, this.maxValidityPeriodHours);
        this.sms.setValidityPeriod(validityPeriod);
    }

    public int getDataCoding() {
        return this.sms.getDataCoding();
    }

    public void setDataCoding(int val) {
        this.sms.setDataCoding(val);
    }

    public void setDataCodingGsm7() {
        this.setDataCoding(0);
    }

    public void setDataCodingGsm8() {
        this.setDataCoding(4);
    }

    public void setDataCodingUcs2() {
        this.setDataCoding(8);
    }

    public int getNationalLanguageSingleShift() {
        return this.sms.getNationalLanguageSingleShift();
    }

    public void setNationalLanguageSingleShift(int val) {
        this.sms.setNationalLanguageSingleShift(val);
    }

    public int getNationalLanguageLockingShift() {
        return this.sms.getNationalLanguageLockingShift();
    }

    public void setNationalLanguageLockingShift(int val) {
        this.sms.setNationalLanguageLockingShift(val);
    }

    public int getEsmClass() {
        return this.sms.getEsmClass();
    }

    public void setEsmClass(int val) {
        this.sms.setEsmClass(val);
    }

    public void setEsmClass_ModeDatagram() {
        this.sms.setEsmClass(MProcUtility.setEsmClass_ModeDatagram(this.sms.getEsmClass()));
    }

    public void setEsmClass_ModeTransaction() {
        this.sms.setEsmClass(MProcUtility.setEsmClass_ModeTransaction(this.sms.getEsmClass()));
    }

    public void setEsmClass_ModeStoreAndForward() {
        this.sms.setEsmClass(MProcUtility.setEsmClass_ModeStoreAndForward(this.sms.getEsmClass()));
    }

    public void setEsmClass_TypeNormalMessage() {
        this.sms.setEsmClass(MProcUtility.setEsmClass_TypeNormalMessage(this.sms.getEsmClass()));
    }

    public void setEsmClass_TypeDeliveryReceipt() {
        this.sms.setEsmClass(MProcUtility.setEsmClass_TypeDeliveryReceipt(this.sms.getEsmClass()));
    }

    public void setEsmClass_UDHIndicatorPresent() {
        this.sms.setEsmClass(MProcUtility.setEsmClass_UDHIndicatorPresent(this.sms.getEsmClass()));
    }

    public void setEsmClass_UDHIndicatorAbsent() {
        this.sms.setEsmClass(MProcUtility.setEsmClass_UDHIndicatorAbsent(this.sms.getEsmClass()));
    }

    public int getPriority() {
        return this.sms.getPriority();
    }

    public void setPriority(int val) {
        this.sms.setPriority(val);
    }

    public int getRegisteredDelivery() {
        return this.sms.getRegisteredDelivery();
    }

    public void setRegisteredDelivery(int val) {
        this.sms.setRegisteredDelivery(val);
    }

    public void setRegisteredDelivery_DeliveryReceiptNo() {
        this.sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptNo(this.sms.getRegisteredDelivery()));
    }

    public void setRegisteredDelivery_DeliveryReceiptOnSuccessOrFailure() {
        this.sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptOnSuccessOrFailure(this.sms.getRegisteredDelivery()));
    }

    public void setRegisteredDelivery_DeliveryReceiptOnFailure() {
        this.sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptOnFailure(this.sms.getRegisteredDelivery()));
    }

    public void setRegisteredDelivery_DeliveryReceiptOnSuccess() {
        this.sms.setRegisteredDelivery(MProcUtility.setRegisteredDelivery_DeliveryReceiptOnSuccess(this.sms.getRegisteredDelivery()));
    }

    public String toString() {
        return "MProcNewMessage: " + this.sms;
    }
}

