/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.mproc.impl;

import java.util.Date;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.OriginationType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.mproc.DeliveryReceiptData;
import org.mobicents.smsc.mproc.MProcMessage;
import org.mobicents.smsc.mproc.OrigType;
import org.mobicents.smsc.mproc.ProcessingType;
import org.mobicents.smsc.mproc.impl.PersistenseCommonInterface;

public class MProcMessageImpl
implements MProcMessage {
    private Sms sms;
    private ProcessingType processingType;
    private PersistenseCommonInterface persistence;

    public MProcMessageImpl(Sms sms, ProcessingType processingType, PersistenseCommonInterface persistence) {
        this.sms = sms;
        this.processingType = processingType;
        this.persistence = persistence;
    }

    protected Sms getSmsContent() {
        return this.sms;
    }

    public int getDestAddrTon() {
        return this.sms.getSmsSet().getDestAddrTon();
    }

    public int getDestAddrNpi() {
        return this.sms.getSmsSet().getDestAddrNpi();
    }

    public String getDestAddr() {
        return this.sms.getSmsSet().getDestAddr();
    }

    public int getNetworkId() {
        return this.sms.getSmsSet().getNetworkId();
    }

    public int getOrigNetworkId() {
        return this.sms.getOrigNetworkId();
    }

    public String getOrigEsmeName() {
        return this.sms.getOrigEsmeName();
    }

    public int getSourceAddrTon() {
        return this.sms.getSourceAddrTon();
    }

    public int getSourceAddrNpi() {
        return this.sms.getSourceAddrNpi();
    }

    public String getSourceAddr() {
        return this.sms.getSourceAddr();
    }

    public String getShortMessageText() {
        return this.sms.getShortMessageText();
    }

    public byte[] getShortMessageBin() {
        return this.sms.getShortMessageBin();
    }

    public OrigType getOriginationType() {
        return OriginationType.toOrigType(this.sms.getOriginationType());
    }

    public Date getScheduleDeliveryTime() {
        return this.sms.getScheduleDeliveryTime();
    }

    public Date getValidityPeriod() {
        return this.sms.getValidityPeriod();
    }

    public int getDataCoding() {
        return this.sms.getDataCoding();
    }

    public int getNationalLanguageSingleShift() {
        return this.sms.getNationalLanguageSingleShift();
    }

    public int getNationalLanguageLockingShift() {
        return this.sms.getNationalLanguageLockingShift();
    }

    public int getEsmClass() {
        return this.sms.getEsmClass();
    }

    public int getPriority() {
        return this.sms.getPriority();
    }

    public String getOriginatorSccpAddress() {
        return this.sms.getOriginatorSccpAddress();
    }

    public int getRegisteredDelivery() {
        return this.sms.getRegisteredDelivery();
    }

    public String getImsiDigits() {
        return this.sms.getSmsSet().getImsi();
    }

    public String getNnnDigits() {
        ISDNAddressString networkNodeNumber;
        LocationInfoWithLMSI locationInfoWithLMSI = this.sms.getSmsSet().getLocationInfoWithLMSI();
        if (locationInfoWithLMSI != null && (networkNodeNumber = locationInfoWithLMSI.getNetworkNodeNumber()) != null) {
            return networkNodeNumber.getAddress();
        }
        return null;
    }

    public int getErrorCode() {
        ErrorCode errorCode = this.sms.getSmsSet().getStatus();
        if (errorCode != null) {
            return errorCode.getCode();
        }
        return 0;
    }

    public ProcessingType getProcessingType() {
        return this.processingType;
    }

    public String toString() {
        return "MProcMessage: " + this.sms;
    }

    public boolean isDeliveryReceipt() {
        return MessageUtil.isDeliveryReceipt(this.sms);
    }

    public DeliveryReceiptData getDeliveryReceiptData() {
        if (this.isDeliveryReceipt()) {
            String msg = this.sms.getShortMessageText();
            DeliveryReceiptData deliveryReceiptData = MessageUtil.parseDeliveryReceipt(msg);
            return deliveryReceiptData;
        }
        return null;
    }

    public Long getReceiptLocalMessageId() {
        return this.sms.getReceiptLocalMessageId();
    }

    public MProcMessage getOriginMessageForDeliveryReceipt(long messageId) {
        if (this.persistence == null) {
            return null;
        }
        try {
            Sms sms = this.persistence.c2_getRecordArchiveForMessageId(messageId);
            if (sms != null) {
                MProcMessageImpl msg = new MProcMessageImpl(sms, this.processingType, null);
                return msg;
            }
            return null;
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            return null;
        }
    }
}

