/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.library;

import org.mobicents.smsc.library.SmsSet;

public class TargetAddress {
    private final int addrTon;
    private final int addrNpi;
    private final String addr;
    private final int networkId;
    private final String targetId;

    public TargetAddress(int addrTon, int addrNpi, String addr, int networkId) {
        this.addrTon = addrTon;
        this.addrNpi = addrNpi;
        this.addr = addr;
        this.networkId = networkId;
        this.targetId = this.formTargetId();
    }

    public TargetAddress(SmsSet smsSet) {
        this.addrTon = smsSet.getDestAddrTon();
        this.addrNpi = smsSet.getDestAddrNpi();
        this.addr = smsSet.getDestAddr();
        this.networkId = smsSet.getNetworkId();
        this.targetId = this.formTargetId();
    }

    private String formTargetId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.addr);
        sb.append("_");
        sb.append(this.addrTon);
        sb.append("_");
        sb.append(this.addrNpi);
        sb.append("_");
        sb.append(this.networkId);
        return sb.toString();
    }

    public String getTargetId() {
        return this.targetId;
    }

    public int getAddrTon() {
        return this.addrTon;
    }

    public int getAddrNpi() {
        return this.addrNpi;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.addrTon;
        result = 31 * result + this.addrNpi;
        result = 31 * result + this.networkId;
        result = 31 * result + (this.addr == null ? 0 : this.addr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TargetAddress other = (TargetAddress)obj;
        if (this.addrTon != other.addrTon) {
            return false;
        }
        if (this.addrNpi != other.addrNpi) {
            return false;
        }
        if (this.networkId != other.networkId) {
            return false;
        }
        return !(this.addr == null ? other.addr != null : !this.addr.equals(other.addr));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetAddress=[");
        sb.append("addr=");
        sb.append(this.addr);
        sb.append(", addrTon=");
        sb.append(this.addrTon);
        sb.append(", addrNpi=");
        sb.append(this.addrNpi);
        sb.append(", networkId=");
        sb.append(this.networkId);
        sb.append("]");
        return sb.toString();
    }
}

